#include "mbed.h"
#include "BLE.h"
#include "HeartRateService.h"
#include "DeviceInformationService.h"


#define NEED_CONSOLE_OUTPUT 1 /* Set this if you need debug messages on the console;
* it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
Serial  pc(USBTX, USBRX);
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

BLE  ble;



void onScanCallback(const Gap::AdvertisementCallbackParams_t *params)
{
    
    

#if NEED_CONSOLE_OUTPUT
    DEBUG("onScan() ");
    DEBUG("RSSI:%d ",params->rssi);
    DEBUG("Addr:%d ",params->peerAddr);
    DEBUG("adv peerAddr[%02x %02x %02x %02x %02x %02x]", params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1],params->peerAddr[0]);
    
    
    DEBUG("Len:%d ",params->advertisingDataLen);
    DEBUG("Data:");
    for (int i=0; i< params->advertisingDataLen; i++){
        DEBUG("%02x,",params->advertisingData[i]);
    }
    DEBUG(" \n\r");
#endif


}

const GapScanningParams scanningParams;
int main(void)
{
   

    ble.init();
    DEBUG("Start\n\r");

    ble.setScanParams(GapScanningParams::SCAN_INTERVAL_MAX,
                      GapScanningParams::SCAN_WINDOW_MAX,
                      0);

    ble.startScan(&onScanCallback);
    // infinite loop
    while (1) {
        ble.waitForEvent(); // low power wait for event
    }
}
