#include "mbed.h"
#include "ble/BLE.h"
#include "ble/services/HeartRateService.h"
#include "ble/services/BatteryService.h"
#include "ble/services/DeviceInformationService.h"
#include "rtos.h"
#include <string.h>

#include "SDFileSystem.h"

Semaphore one_slot(1);
 
 
 BLE  ble;
int address[10][12]={};
const GapScanningParams scanningParams;
int wt;
SDFileSystem sd(p25, p28, p29, p21, "sd"); // the pinout on the mbed Cool Components workshop board
FILE *fp;

int counter= 0;
void onScanCallback(const Gap::AdvertisementCallbackParams_t *params)
{
    time_t seconds = time(NULL); // JST
     struct tm *t = localtime(&seconds);
     /*printf("%04d/%02d/%02d %02d:%02d:%02d\r\n",
      t->tm_year + 1900, t->tm_mon, t->tm_mday, t->tm_hour, t->tm_min, t->tm_sec);
    */

    int i=0,a=0,b=0,flag=0;
    for(i=0;i<10;i++){
        if(address[i][0]==params->peerAddr[0]){
            flag=1;
            break;
        }
    }    
    if(flag==0){
        for(i=0; i<6; i++){
            address[counter][i]=params->peerAddr[i];
         }
        time_t seconds = time(NULL);
        struct tm *t = localtime(&seconds);
        address[counter][6]=t->tm_year;
        address[counter][7]=t->tm_mon;
        address[counter][8]= t->tm_mday;
        address[counter][9]= t->tm_hour;
        address[counter][10]= t->tm_min;
        address[counter][11]= t->tm_sec;
//ファイルをオープン
fp = fopen("/sd/test.txt", "w");

        
        fprintf(fp,"DEV:");
        for(b=0; b<6 ; b++){
                fprintf(fp,"%02x ", address[counter][b]);
        }        
        printf("OK1");
        fprintf(fp,"%04d/%02d/%02d %02d:%02d:%02d \r\n",address[counter][6],address[counter][7],address[counter][8],address[counter][9],address[counter][10],address[counter][11]);
        printf("OK2");
        
fclose(fp);
         counter++;
             
/*          for(a=0; a<counter; a++){
             for(b=0; b<6 ; b++){
                if(b==0)printf("DEV:");
                printf("%02x ", address[a][b]);
                if(b==5){
                printf("%04d/%02d/%02d %02d:%02d:%02d \r\n",address[a][6],address[a][7],address[a][8],address[a][9],address[a][10],address[a][11]);
                    }
             }
             if(a==counter-1)printf("----------\n\r");
           }         */
    }
 
 
 /*   for(int i=0; i<6; i++){
        address[0][i]=params->peerAddr[5-i];
    }
    for(int b=0; b<6 ; b++){
        if(b==0)printf("DEV:");
        printf("%02x ", address[0][b]);
        if(b==5)printf("\n\r");
    }*/        
}


void test_thread(void const *name) {    
    
    
    while (true) {
        Timer timer;
        one_slot.wait();
        printf("%s\n\r", (const char*)name);
//1
        if(!strcmp((const char*)name, "1")){
            printf("**this is 1**\n\r");
            wt=1000;
            ble.gap().stopAdvertising();
            ble.startScan(&onScanCallback);
        
        }

//2        
        if(!strcmp((const char*)name, "2")){
            memset(address, 0, sizeof(address));
            printf("**this is 2**\n\r");
            wt=10000;
            timer.start();
            while(1){
                ble.waitForEvent();
                if(timer.read() > 9){
                        timer.stop();
                        timer.reset();
                        ble.stopScan();
                        break;
                }
            }
        }
//3        
        if(!strcmp((const char*)name, "3")){
            printf("**this is 3**\n\r");        
             wt=20000;
            ble.gap().startAdvertising();

        }
        
        
        Thread::wait(wt);
        one_slot.release();
    }
}
 
// const static char     DEVICE_NAME[]        = "BLE1";
    
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &ble          = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        return;
    }
    const uint8_t address1[] = {0xAA,0xAA,0xAA,0xAA,0xAA,0xAA};
    ble.gap().setAddress(BLEProtocol::AddressType::PUBLIC, address1);
//  ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
//   ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
//   ble.gap().setAdvertisingInterval(1000); /* 1000ms. */
}
 
int main (void) {

    

    
    
    //ble.init();
    ble.init(bleInitComplete);
    ble.setScanParams(GapScanningParams::SCAN_INTERVAL_MAX,
                      GapScanningParams::SCAN_WINDOW_MAX,
                      0);


    Thread t2(test_thread, (void *)"2");
    Thread t3(test_thread, (void *)"3");
    
    test_thread((void *)"1");

}