#include "mbed.h"
// Ethernet
#include "EthernetInterface.h"
// MFRC522(RFID)
#include "MFRC522.h"

#define WEB_SERVER_PORT   80

Serial pc(USBTX, USBRX);

// MFRC522 reset (pick another D pin if you need D8)
#define MF_RESET    D8
// Buzzer
#define VOLUME 0.02
#define BPM 100.0
// LED
DigitalOut Led(LED1);

// Buzzer
PwmOut pwm_pin(D3);
 
float beat_duration;
// Plays a sound with the defined frequency, duration, and volume
void playNote(float frequency, float duration, float volume) {
    pwm_pin.period(1.0/(double)frequency);
    pwm_pin = ((double)volume/2.0);
    wait(duration);
    pwm_pin = 0.0;
}

// CARD number
uint8_t CARD_1 = 0x44;
uint8_t CARD_2 = 0xCB;
uint8_t CARD_3 = 0x2A;
uint8_t CARD_4 = 0xA4;

uint8_t CARD_5 = 0xA2;
uint8_t CARD_6 = 0xCE;
uint8_t CARD_7 = 0xEC;
uint8_t CARD_8 = 0xD5;

// RC522 SPI communication
MFRC522    RfChip   (D11, D12, D13, D10, MF_RESET);

//HTTP WEB SERVER
char recv_buffer[1024] = {0,};
char echoHeader[1024] = {0,};
char * findrfid = 0;
char change_rfid[4] = {1,2,3,4};

int main (void) 
{
    // Init. RC522 Chip
    RfChip.PCD_Init();
    pc.printf("Init end\r\n");
    // WEB SERVER Start
    printf("Wait a second...\r\n");
    // IP Setting..
    #ifdef dhcp
        uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
        EthernetInterface eth;
        eth.init(mac_addr); //Use DHCP
        eth.connect();
    #else
        uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02};
        char ip_addr[] = "192.168.1.111";
        char subnet_mask[] = "255.255.255.0";
        char gateway_addr[] = "192.168.1.1";
        EthernetInterface eth;
        eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
        
        while(1) { //Wait link up
        if(eth.link() == true)
            break;
        }
        printf("Check Ethernet Link\r\n");
        printf("Link up\r\n");
    #endif

    //eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(WEB_SERVER_PORT);
    printf("bind complete\r\n");
    server.listen();
    printf("listen complete\r\n");
    while (true) 
    {    
        printf("Wait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s
        
        printf("Connection from: %s\r\n", client.get_address());

        while (true) {            
            int n = client.receive(recv_buffer, sizeof(recv_buffer));
            if (n <= 0) break; // n = n < 0
            
            // print received message to terminal
            recv_buffer[n] = '\0';
            printf("Received message from Client :'%s'\r\n",recv_buffer);
            if(recv_buffer[0] == 'G' && recv_buffer[1] == 'E' && recv_buffer[2] == 'T')
            {
                printf("GET request incomming.\n\r");
                
                //setup http response header + data
                char send_buffer[] = "<!DOCTYPE HTML>\r\n\n\r<html>\n\r\n\r\n\r<head>\n\r<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\">\n\r<title>Wizwiki-W7500 Web Server</title>\n\r<meta name=\"generator\">\n\r</head>\n\r\n\r<body bgcolor=\"white\" text=\"black\" link=\"blue\" vlink=\"purple\" alink=\"red\">\r\n<p>Wizwiki-W7500 Home-Automation RFID</p>\r\n<p>Read RFID = $$$$$$$$$$$</p>\r\n</body>\n\r</html>\r\n";
                
                findrfid = strstr(send_buffer, "$$$$$$$$$$$");
                memset(findrfid,0,11);
                sprintf(change_rfid, "%X,%X,%X,%X", RfChip.uid.uidByte[0],RfChip.uid.uidByte[1],RfChip.uid.uidByte[2],RfChip.uid.uidByte[3]);
                memcpy(findrfid,change_rfid,11);                  
                
                sprintf(echoHeader,"HTTP/1.1 200 OK\n\rContent-Length: %d\n\rContent-Type: text/html\n\rConnection: Closen\n\rRefresh: 5\n\r\n\r\n\r",strlen(send_buffer));
                client.send(echoHeader,strlen(echoHeader));
                client.send(send_buffer,strlen(send_buffer));
                
                // RFID Area
                // Look for new cards
                if ( ! RfChip.PICC_IsNewCardPresent())
                {
                  wait_ms(500);
                  continue;
                }
                // Select one of the cards
                if ( ! RfChip.PICC_ReadCardSerial())
                {
                  wait_ms(500);
                  continue;
                }
                // Print Card UID
                pc.printf("Card UID: ");
                for (uint8_t i = 0; i < RfChip.uid.size; i++)
                {
                  pc.printf(" %X02", RfChip.uid.uidByte[i]);
                }
                pc.printf("\n\r");
                // Print Card type
                uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
                pc.printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
                wait_ms(1000);
                
                // Show RFID Tag 
                if((RfChip.uid.uidByte[0] == CARD_1) && (RfChip.uid.uidByte[1] == CARD_2) && (RfChip.uid.uidByte[2] == CARD_3) && (RfChip.uid.uidByte[3] == CARD_4))
                {
                    // Buzzer Sound
                    pc.printf("TAG Read !\r\n");
                    beat_duration = 60.0 / BPM;
                    playNote(999.999, (0.75 * (double)beat_duration), VOLUME);
                }
                // Show RFID Card
                else if((RfChip.uid.uidByte[0] == CARD_5) && (RfChip.uid.uidByte[1] == CARD_6) && (RfChip.uid.uidByte[2] == CARD_7) && (RfChip.uid.uidByte[3] == CARD_8))
                {
                    pc.printf("CARD Read !\r\n");
                    beat_duration = 60.0 / BPM;
                    playNote(111.111, (0.75 * (double)beat_duration), VOLUME);
                }
            }
            if (n <= 0) break;
        }
        client.close();
    }
}