// Nucloe_L152RE_W5500_Ethernet shield Exmaple

#include "mbed.h"
#include "WIZnetInterface.h"
#include "SDFileSystem.h"
#include "UDPSocket.h"

//#define USE_DHCP    1 // DHCP 사용할때 사용
//#define USE_UDP     1
#define USE_TCP     1

#define TCP_PORT    5000
#define UDP_PORT    7000

const char * IP_Addr    = "192.168.0.194";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.0.1";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x01,0x02,0x03};

const char * UDP_IP = "0.0.0.0";

SDFileSystem sd(PA_7, PA_6, PA_5, PB_5, "sd");

DigitalOut myled1(LED1);
Serial pc(USBTX, USBRX);

SPI spi(PA_7, PA_6, PA_5); // mosi, miso, sclk
WIZnetInterface ethernet(&spi, PB_6, PC_7);//scs(PB_6), nRESET(PA_9); // reset pin is dummy, don't affect any pin of WIZ550io

int main() {

    //Set serial port baudrate speed: 115200
    pc.baud(115200);
    wait(10);
    pc.printf("W5500 Application Started \r\n");

    char buffer[256];
    
    //SD-CARD
    printf("Hello World!\n");   
    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp); 
    printf("Goodbye World!\n");
    //SD-CARD END 
    
    while(1)
    {
        #if USE_DHCP
        pc.printf("DHCP ON \r\n");
        int ret = ethernet.init(MAC_Addr);
        #else
        pc.printf("DHCP OFF \r\n");
        int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
        #endif
        
        
        printf("SPI Initialized \r\n");
        wait(1); // 1 second for stable state
        
        printf("W5500 Networking Started \r\n");
        wait(1); // 1 second for stable state
        
        
        if (!ret) {
            pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
            ret = ethernet.connect();
            if (!ret) {
                pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                          ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
            } else {
                pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
                exit(0);
            }
        } else {
            pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
            exit(0);
        }
#if USE_UDP
        UDPSocket UDP_server;
        UDP_server.init();
        Endpoint nist;
        
        nist.set_address(UDP_IP, UDP_PORT);
        UDP_server.bind(UDP_PORT);
        pc.printf("UDP PORT %d \r\n", UDP_PORT);
        pc.printf("\nWait for message...\r\n");
        
        while (1) {
            int n = UDP_server.receiveFrom(nist, buffer, sizeof(buffer));
            if(n > 0){
                UDP_server.sendTo(nist, buffer, n);
            }
        }
#endif
#if USE_TCP
        TCPSocketServer server;
        server.bind(TCP_PORT);
        pc.printf("TCP PORT %d \r\n", TCP_PORT);
        server.listen();
        
        while (1) {
            pc.printf("\nWait for new connection...\r\n");
            TCPSocketConnection client;
            server.accept(client);
            //client.set_blocking(false, 0); // Timeout=0.
            pc.printf("Connection from: %s\r\n", client.get_address());
            while (client.is_connected() == true) {
                int n = client.receive(buffer, sizeof(buffer));
                if(n > 0)
                    client.send_all(buffer, n);
                if(client.is_fin_received())
                    client.close();
            }
            pc.printf("Disconnected.\r\n");
        }
#endif
    }
}
