#include "mbed.h"
#include <vector>
#include <string>
#include <algorithm>
#include <iostream>
#include <iomanip>
#include "uLCD_4DGL.h"
#include "Speaker.h"


//puzzle with hint
std::string puzz[11][2] = {
    {"SAYING", "TO HELL WITH GEORGIA"},
    {"HOME SWEET HOME", "VAN LEER"},
    {"1913", "BOBBY DODD STADIUM"},
    {"NAND", "DIGITAL DESIGN"},
    {"RULES 1&2", "KIRCHHOFF'S LAWS"},
    {"HARMONICS", "FOURIER SERIES"},
    {"VR", "TRANSFORMER"},
    {"J'HABITE", "GT LORRAINE"},
    {"GRADUATION", "DEGREE WORKS"},
    {"PAIN", "STUDENT LOANS"},
    {"EXPERIENCE", "INTERSHIP"}
};



Serial pc(USBTX,USBRX); //talk to pc
DigitalOut myled(LED1); //led for debugging
DigitalIn pb(p8); //button
uLCD_4DGL uLCD(p9,p10,p11); // ulcd serial tx, serial rx, reset pin;
PwmOut speaker(p21); //speaker



int main()
{

    uLCD.cls(); // clear ulcd
    uLCD.baudrate(9600); //change baud rate
    int x=4;
    int x2=6;
    int color=GREEN; //rectangle color iss green
    int i=0;
    double power;
    int val;

    pb.mode(PullUp); //internal pullup for button
    uLCD.color(RED); //make text red
    uLCD.locate(1,6);
    uLCD.printf("Power");//label
    uLCD.locate(1,9);
    uLCD.printf("Low");//label
    uLCD.locate(14,9);
    uLCD.printf("High");//label
    uLCD.rectangle(3, 59, 125, 69,RED ); //make rectangle outline red
    int r;
    int end=0;
    r=rand()%11; //to choose a random puzzle
    while(1) {

        //make power bar that goes back and forth
        uLCD.filled_rectangle(x,60, x2,68,color);

        if (x2<124 && i==0) {
            x=x+2;
            x2=x2+2;
        } else if (x2>4 && i==1) {
            x=x-2;
            x2=x2-2;
        }
        if(x2==124) {
            i=1;
            color=BLACK;
        } else if(x2==4) {
            i=0;
            x=4;
            x2=6;
            color=GREEN;
        }

        //when button is pushed
        if (pb==0) {
            end=1;
            wait(.5);
        }
        //if data sent over comport
        if(pc.readable()) {
            char g= pc.getc();
            uLCD.locate(4,1);

            uLCD.locate(6,1);
            //return puzzle string
            if (g=='v') {
                for (int y=0; y<puzz[r][1].size(); y++) {
                    pc.putc(puzz[r][1][y]); //return puzzle
                }


            }
            //return puzzle's hint
            if (g=='k') {
                for (int y=0; y<puzz[r][0].size(); y++) {
                    pc.putc(puzz[r][0][y]); //return hint

                }

                r=rand()%11; //store new random number
                g=' ';
            }
            //if player changed make noise
            if(g=='b') {
                speaker.period(1.0/100.0); // 100hz period
                speaker =0.3; //3% duty cycle - max volume
                wait(.2);
                speaker=0;
                wait(.05);
                speaker.period(1.0/100.0); // 100hz period
                speaker =0.3; //30% duty cycle - max volume
                wait(.2);

                speaker=0;

                g=' ';
            }


        }
    //if button pushed send power value to pc using rectangle coord.
        if(end==1) {

            power=((x2-double(6))/double(118)); //decimal value
            val=power*100; //power out of 100
            uLCD.locate(1,1);
            if(val!=NULL) {
                pc.putc(val); //print to pc

            }

            end=0;
        }

    }
}

