#include "mbed.h"
#include "Speaker.h"
#include "uLCD_4DGL.h"

//Mbed I/O
DigitalIn player_hit(p10); // up direction, determine if the player wants another card from the navigation switch
DigitalIn player_stay(p11); // down direction, determine if the player wants to stay with the current cards he has.
PwmOut speaker(p21); //play short sound when card placed on table
uLCD_4DGL uLCD(p28, p27, p30); //uLCD connection

//global variables
int money = 5; // picked 5 dollars to start with. each bet/round is only 1 dollar automatically taken out as long as player decides to keep playing.
int dealer_hand[2]; // array of two to hold the dealers cards
int player_hand[2]; // array of two to hold the players cards
int x; // indexing for the cards
int dealer_card; //random card value to be assigned to dealer
int player_card; // random card value to be assigned to player
int player_total; // deterines the total value of the players hand
int dealer_total; // determines the total value of the dealers hand
bool y = true; //determines when to be in a while loop in functions below
int hi, lo; //determines card picture address on sd card in uLCD device
int k,j; //determines the card position of player and dealer
int flip1, flip2; //store hi and lo value of dealer's second card to flip later
int num,num2; //determines the card face for player and dealer
int ace1=0; //keeps track of player's aces
int ace2=0; //keeps track of dealer's aces
int card[13]= {2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 10, 11}; //used to choose a random value


void addr(int, int); //glocalize the function to find the card address for other function use
int place_cards(int); //globalize the funtion to determine the card position for other function use

//deals out 2 cards faced up to player and one card faced up and one card faced down to the dealer
void deal_hand(void)
{
    ace1=0;
    ace2=0;
    int m;
    int mat[4]= {10,11,12,13}; //case values of cards with value 10 (10, J, Q, K)
    int suit; //card suit
    srand (time(NULL));

    while (x<=1) {

        player_card= rand() % (12 + 1 - 0) + 0; //random index value 0-12
        player_card=card[player_card]; //use random index to find value in array
        if(player_card==10) {
            m= rand() % (3 + 1 - 0) + 0; //use random card with value 10 in case statement
            m=mat[m];
        } else if (player_card==11) { //ace is 1 in case statement
            m=1;
            ace1++;
        } else {
            m=player_card;  //other numbers match case statement
        }
        suit= rand() % 4 + 1; //random suit
        addr(m, suit); //find card address
        uLCD.media_init();
        uLCD.set_sector_address(hi, lo); //use card address from sd
        j=place_cards(num); //determine next card placement
        uLCD.display_image(4,j); //display card

        speaker.period(1.0/500.0); // 500hz period
        speaker =0.5; //50% duty cycle - max volume
        wait(.1);
        speaker=0.0; // turn off audio
        wait(2);

        num++;

        dealer_card= rand() % (12 + 1 - 0) +0; //random index value 0-12
        dealer_card=card[dealer_card]; //use random index value to find value

        if(dealer_card==10) {
            m= rand() % (3 + 1 - 0) + 0; //use random card with value 10 in case statement
            m=mat[m];
        } else if (dealer_card==11) { //ace is 1 in case statement
            m=1;
            ace2++;
        } else {
            m=dealer_card; //other numbers match case statement
        }

        suit= rand() % 4 + 1; //use a random suit
        addr(m, suit); //find address
        k=place_cards(num2); //determine next card placement

        //store the dealer's second card image address
        if (num2==1) {
            flip1=hi;
            flip2=lo;
            hi=0x0040;
            lo=0x0001;
        }

        uLCD.media_init();
        uLCD.set_sector_address(hi, lo); //use card address from sd
        uLCD.display_image(70,k); //diplay card

        //play beep
        speaker.period(1.0/500.0); // 500hz period
        speaker =0.5; //50% duty cycle - max volume
        wait(.1);
        speaker=0.0; // turn off audio
        wait(2);

        num2++;

        dealer_hand[x]= dealer_card; //put dealer card value in array
        player_hand[x]= player_card; //put player card value in array

        x= x+1; //next array index slot
    }

    player_total= player_hand[0] + player_hand[1]; // determines the players total from his two original cards
    dealer_total= dealer_hand[0] + dealer_hand[1]; // determines the dealers total from his two original cards
    x= 0; //reset index to 0
}

//player decides to hit or stay
void player_decision(void)
{
    int suit;
    uLCD.locate(0,14);
    uLCD.printf ("Hit (UP) or stay(DOWN)?"); //print user
    y= true;
    int mat[4]= {10,11,12,13}; //case values of cards with value 10 (10, J, Q, K)
    int m;
    while (y) {
        if (player_hit ==0) { //player hits

            srand (time(NULL));
            player_card= rand() % (12 + 1 - 0) + 0; //random index 0-12
            player_card=card[player_card]; //use index to find value
            // Can display the extra card they recieve

            if(player_card==10) {
                m= rand() % (3 + 1 - 0) + 0; //use random card with value 10 in case statement
                m=mat[m];
            } else if (player_card==11) { //ace is 1 in case statement
                m=1;
                ace1++;
            } else {
                m=player_card; //other card values match case statement values
            }

            suit= rand() % 4 + 1; //random suit
            addr(m, suit); //find address of card image
            uLCD.media_init(); //
            uLCD.set_sector_address(hi, lo); //use address
            j=place_cards(num); //find where to place card
            uLCD.display_image(4,j); //display card

            //play beep
            speaker.period(1.0/500.0); // 500hz period
            speaker =0.5; //50% duty cycle - max volume
            wait(.1);
            speaker=0.0; // turn off audio
            wait(1);
            num++;

            player_total= player_total + player_card; //find total
            wait(.5);

            if (player_total >21 && ace1>=1) { //change ace to 1
                player_total= player_total-10;
                ace1--;
                player_decision(); //call this function
            } else if (player_total>21) {
                // print to the screen that the player bust
                uLCD.locate(1,7);
                uLCD.printf ("You BUSTED!\n\r ");
                wait(2);
                uLCD.cls();
                y= false;
            } else if (player_total<21) { //continue prompt
                uLCD.locate(0,14);
                uLCD.printf ("Hit (UP) or stay(DOWN)?");
                player_decision();
            }

        }

        else if (player_stay ==0) {
            //get rid of prompt question
            uLCD.textbackground_color(0x006600);
            uLCD.color(0x006600);
            uLCD.locate(0,14);
            uLCD.printf ("Hit (UP) or stay(DOWN)?");
            uLCD.textbackground_color(BLACK);
            uLCD.color(RED);
            y= false; //get out of while loop
            wait(.5);
        }

    }
}

void dealer_decision(void)
{
    int suit;
    int m;
    int mat[4]= {10,11,12,13}; //case values of cards with value 10 (10, J, Q, K)
    while (dealer_total <17) { //dealer will hit if it's total is under 17

        srand (time(NULL));
        dealer_card= rand() % (12 + 1 - 0) + 0; //find random index 0-12
        dealer_card=card[dealer_card]; //use index to find value in array
        if(dealer_card==10) { //cards with 10 value in switch are 10, 11, 12, 13
            m= rand() % (3 + 1 - 0) + 0;
            m=mat[m];
        } else if (dealer_card==11) { //ace value in switch is 1
            m=1;
            ace2++;
        } else {
            m=dealer_card; //other card values match switch case value
        }
        suit= rand() % 4 + 1;
        addr(m, suit); //find card address
        uLCD.media_init();
        uLCD.set_sector_address(hi, lo); //use card address found
        k=place_cards(num2); //find card loaction
        uLCD.display_image(70,k); //display card

        //play beep
        speaker.period(1.0/500.0); // 500hz period
        speaker =0.5; //50% duty cycle - max volume
        wait(.1);
        speaker=0.0; // turn off audio
        wait(.5);
        num2++; //next card

        dealer_total= dealer_total + dealer_card; //total

        wait(.5);
        if (dealer_total> 21 && ace2>=1) { //change ace to 1
            dealer_total= dealer_total-10;
            ace2--;
            dealer_decision();
        } else if (dealer_total>21) {
            // print to the screen that the dealer bust
            uLCD.locate(4, 7);
            uLCD.printf ("Dealer BUSTED!");
            wait(3);
            uLCD.cls();
            y= false; //leave while loop
        }
        wait(2);
    }
    //if dealer doesn't bust and has higher value than player
    if(dealer_total>player_total && dealer_total<=21) {
        uLCD.locate(2,7);
        uLCD.printf("Dealer Wins!");
        wait(3);
        uLCD.cls();
    }
    //if player and dealer totals are equal it's a tie
    else if(dealer_total==player_total && dealer_total<=21) {
        uLCD.locate(5,5);
        uLCD.printf("It's a Tie!");
        wait(3);
        uLCD.cls();
    }
    //if player's total is greater than dealers
    else if(dealer_total<player_total && dealer_total<=21) {
        uLCD.locate(2,7);
        uLCD.printf("You Win!");
        wait(3);
        uLCD.cls();
    }
}


//find address of card using switch
void addr(int num, int suit)
{
    switch(num) {
        case 1: //Ace
            if(suit==1) { //clubs
                hi=0x003F;
                lo=0xFFC1;
                // break;
            } else if(suit==2) { //diamond
                hi=0x003F;
                lo=0xFFD1;
                //   break;
            } else if(suit==3) { //hearts
                hi=0x003F;
                lo=0xFFE1;
            } else if(suit==4) { //spades
                hi=0x003F;
                lo=0xFFF1;
            }
            break;
        case 2:

            if(suit==1) {
                hi=0x0040;
                lo=0x02CB;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x02DB;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x02EB;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x02FB;
            }

            break;

        case 3:

            if(suit==1) {
                hi=0x0040;
                lo=0x028B;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x029B;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x02AB;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x02BB;
            }

            break;
        case 4:

            if(suit==1) {
                hi=0x0040;
                lo=0x0090;
                // break;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x009F;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x00AF;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x00BF;
            }

            break;
        case 5:
            if(suit==1) {
                hi=0x0040;
                lo=0x0050;
                //break;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x0060;
                // break;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x0070;
                // break;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x0080;
            }

            break;
        case 6:

            if(suit==1) {
                hi=0x0040;
                lo=0x020D;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x021D;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x022D;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x023D;
            }

            break;
        case 7:

            if(suit==1) {
                hi=0x0040;
                lo=0x01CE;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x01DD;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x01ED;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x01FD;
            }

            break;
        case 8:
            if(suit==1) {
                hi=0x0040;
                lo=0x0010;
                //  break;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x0020;
                //  break;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x0030;
                //  break;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x0040;
            }

            break;
        case 9:
            if(suit==1) {
                hi=0x0040;
                lo=0x014F;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x015F;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x016F;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x017F;
            }

            break;
        case 10:
            if(suit==1) {
                hi=0x0040;
                lo=0x024C;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x025B;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x026B;

            } else if(suit==4) {
                hi=0x0040;
                lo=0x027B;
            }

            break;
        case 11: //Jack
            if(suit==1) {
                hi=0x0040;
                lo=0x00CF;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x00DF;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x00EF;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x00FF;
            }

            break;
        case 12: //Queen
            if(suit==1) {
                hi=0x0040;
                lo=0x018F;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x019E;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x01AE;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x01BE;
            }

            break;
        case 13: //King
            if(suit==1) {
                hi=0x0040;
                lo=0x010F;
            } else if(suit==2) {
                hi=0x0040;
                lo=0x011F;
            } else if(suit==3) {
                hi=0x0040;
                lo=0x012F;
            } else if(suit==4) {
                hi=0x0040;
                lo=0x013F;
            }

            break;
    }

}

//displace cards down screen
int place_cards(int num)
{
    int j=14*num+9;
    return(j);
}

int main()
{
    uLCD.cls();
    uLCD.background_color(0x006600);
    while (money > 0) {
        uLCD.cls();
        uLCD.color(RED);
        uLCD.set_font(FONT_7X8);
        uLCD.locate(1,0);
        uLCD.printf("Player"); //print Player
        uLCD.locate(11,0);
        uLCD.printf("Dealer"); //print Dealer
        num=0;
        num2=0;
        srand (time(NULL));
        //start with 2 cards for player and dealer
        deal_hand();
        //prompt player
        player_decision();
        //go to dealer and flip 2nd card over
        if(player_total<=21) {
            uLCD.media_init();
            uLCD.set_sector_address(flip1, flip2); //use saved address
            uLCD.display_image(70,k); //display card
            speaker.period(1.0/500.0); // 500hz period
            speaker =0.5; //50% duty cycle - max volume
            wait(.1);
            speaker=0.0; // turn off audio
            wait(2);
            //if dealer is under 17 in total the dealer will hit
            dealer_decision();
        }
        //1 money point awarded for a win
        //1 money point taken away for a loss
        if (player_total== dealer_total) {
            money=money;
            uLCD.locate(2, 2);
            uLCD.printf ("money= %d", money);
        } else if (player_total > 21) {
            money= money -1;
            uLCD.locate(2, 2);
            uLCD.printf ("money= %d", money);
        } else if (dealer_total >21) {
            money= money+1;
            uLCD.locate(2, 2);
            uLCD.printf ("money= %d", money);
        } else if ((player_total > dealer_total)) {
            money = money+1;
            uLCD.locate(2, 2);
            uLCD.printf ("money= %d", money);
            // Display that its a tie
            //return back to the beginning for new game
        } else if ((player_total < dealer_total)) {
            money= money-1;
            uLCD.locate(2, 2);
            uLCD.printf ("money= %d", money);
            // display dealer wins
            //return back to the beginning for new game
        }
        wait(3);

    }
//Game Over
    wait(1);
    uLCD.cls();
    uLCD.locate(4,5);
    uLCD.printf("Game Over!");
    wait(4);



}
