#include "mbed.h"
#include "pwm_tone.h"
#include "Hexi_OLED_SSD1351.h"

#include "IotMainImage.h"
#include "string.h"

#include "Hexi_KW40Z.h"
#include "FXOS8700.h"

#define LED_ON      0
#define LED_OFF     1


/*------------------FUNCTIONS-------------------------------------------------*/

//Defining functions for haptic feedback
void StartHaptic(void);
void StopHaptic(void const *n);

//LED functions
DigitalOut redLed(LED1);
DigitalOut greenLed(LED2);
DigitalOut blueLed(LED3);
DigitalOut haptic(PTB9);

// Pin connections
DigitalOut led1(LED_GREEN); // RGB LED
FXOS8700 accel(PTC11, PTC10);
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); // SSD1351 OLED Driver (MOSI,SCLK,POWER,CS,RST,DC)

// Define the Buzzer Pinout (PWM Out)
PwmOut Buzzer(PTA10);

// Define timer for haptic feedback
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

// Instantiate the Hexi KW40Z Driver (UART TX, UART RX)
KW40Z kw40z_device(PTE24, PTE25);

/*------------------VARIABLES-------------------------------------------------*/

float C_3 =  1000000/Do3,                                                      
      Cs_3 = 1000000/Do3s,        
      D_3 =  1000000/Re3,                                                       
      Ds_3 = 1000000/Re3s,
      E_3 =  1000000/Mi3,
      F_3 =  1000000/Fa3,
      Fs_3 = 1000000/Fa3s,
      G_3 =  1000000/So3,
      Gs_3 = 1000000/So3s,
      A_3 =  1000000/La3,
      As_3 = 1000000/La3s,
      B_3 =  1000000/Ti3,
      C_4 =  1000000/Do4,
      Cs_4 = 1000000/Do4s,
      D_4 =  1000000/Re4,
      Ds_4 = 1000000/Re4s,
      E_4 =  1000000/Mi4,
      F_4 =  1000000/Fa4,
      Fs_4 = 1000000/Fa4s,
      G_4 =  1000000/So4,
      Gs_4 = 1000000/So4s,
      A_4 =  1000000/La4,
      As_4 = 1000000/La4s,
      B_4 =  1000000/Ti4,
      C_5 =  1000000/Do5,
      Cs_5 = 1000000/Do5s,
      D_5 =  1000000/Re5,
      Ds_5 = 1000000/Re5s,
      E_5 =  1000000/Mi5,
      F_5 =  1000000/Fa5,
      Fs_5 = 1000000/Fa5s,
      G_5 =  1000000/So5,
      Gs_5 = 1000000/So5s,
      A_5 =  1000000/La5,
      As_5 = 1000000/La5s,
      B_5 =  1000000/Ti5,
      C_6 =  1000000/Do6,  
      Cs_6 = 1000000/Do6s, 
      D_6  = 1000000/Re6,   
      Ds_6 = 1000000/Re6s,
      E_6  = 1000000/Mi6,
      F_6  = 1000000/Fa6,  
      Fs_6 = 1000000/Fa6s, 
      G_6  = 1000000/So6, 
      Gs_6 = 1000000/So6s,
      A_6  = 1000000/La6,  
      As_6 = 1000000/La6s, 
      B_6 =  1000000/Ti6;  
      
//Notes defined by a million/defined value in pwm_tone.h file
//Organize code such that all variables in .h file and all functions in seperate .cpp file for simpler debugging
//Song tones-------------------------------------------------------------------

//Marry had a little lamb red led, leftmost button
int tones1[] = {E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0,   D_4, D_4, D_4, 0,   \
                E_4, G_4, G_4, 0,   E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0,   \
                D_4, D_4, E_4, D_4, C_4, 0,   0,   0};
                //done
                
//Senya -Itachi theme 
int tones2a[] = {G_5, Gs_5, G_5, Ds_5, F_5,  0, Ds_5, F_5, Ds_5, As_4, D_5, \
                 0};
                //C_5(4), Ds_5(4), As_4(4), C_5(12)
                //x3    
                 
int tones2b[] = {C_5, D_5, Ds_5, D_5, C_5, As_4, C_5, D_5, F_5}; 
                //Ds_5(12) 
                //x3 twice as slow   

int tones2c[] = {C_5, D_5, Ds_5, D_5, C_5, As_4, C_5, D_5, F_5, D_5};
                //C_5(8) 
                //x1 twice as slow





int tones3[] = {As_3, A_3, Gs_3, G_3, Fs_3, F_3, E_3, Ds_3, D_3, Cs_3, C_3, 0,\
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
               };
               
//OneRepublic -Secrets
int tones4[] = {D_4, F_4, A_4, F_4, A_4, F_4, D_4, F_4, D_4, F_4, A_4, F_4, \
                A_4, F_4, D_4, F_4, C_4, F_4, A_4, F_4, A_4, F_4, C_4, F_4, \
                C_4, F_4, A_4, F_4, A_4, F_4, C_4, F_4, B_3, D_4, B_4, D_4, \
                B_4, D_4, B_3, D_4, B_3, D_4, B_4, D_4, B_4, D_4, B_3, D_4, \
                G_3, D_4, B_4, D_4, B_4, D_4, B_4, D_4, 0,   0,   A_4, A_4, \
                A_4, A_4, A_4};  
                //12 notes per row, done
                
//Number of tones---------------------------------------------------------------

int tones_num1 = 32; // Auto performance, 32 notes max
int tones_num2 = 63; // Auto performance, 23 notes max
int tones_num3 = 12; // Auto performance, 12 notes max
int tones_num4 = 9;  // Auto performance, 9 notes max  
int i;
Timer t;

const uint8_t *image1; // Pointer for the image1 to be displayed
char text1[20]; // Text Buffer for dynamic value displayed
char text2[20]; // Text Buffer for dynamic value displayed
char text3[20]; // Text Buffer for dynamic value displayed
char text4[20]; // Text Buffer for dynamic value displayed
char text5[20]; // Test Buffer for dynamic value displayed
char text6[20]; // Text Buffer for dynamic value displayed

/*------------------FUNCTIONS-------------------------------------------------*/

//------------------RED LED-----------------------------------------------------
void ButtonLeft(void)
{
    StartHaptic();
    redLed      = LED_ON;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;

     // Fill 96px by 96px Screen with 96px by 96px NXP Image starting at x=0,y=0
    oled.DrawImage(image1,0,0);
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);
    
    /* Set text properties to white and right aligned for the dynamic text */
    textProperties.fontColor = COLOR_YELLOW;
    textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
    oled.SetTextProperties(&textProperties);
    /* Display text2 */
    strcpy((char *) text1,"When red LED");
    oled.Label((uint8_t *)text1,3,28);
    /* Display text3 */
    strcpy((char *) text2,"turns off, press"); //17 characters max length per statement
    oled.Label((uint8_t *)text2,3,41);
    /* Display text4 */
    strcpy((char *) text3,"another button");
    oled.Label((uint8_t *)text3,3,54);
    /* Display text5 */
    strcpy((char *) text4,"to play");
    oled.Label((uint8_t *)text4,3,67);
    /* Register callbacks to application functions */
    strcpy((char *)text5,"another song");
    oled.Label((uint8_t *)text5,3,80);

    for(i=0; i<tones_num1; i++) 
    {
        Auto_tunes(Buzzer, tones1[i], 4); // Auto performance
        Stop_tunes(Buzzer);
    }
    
    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;
}
//-------------------------GREEN LED--------------------------------------------
void ButtonRight(void)
{
    StartHaptic();

    redLed      = LED_OFF;
    greenLed    = LED_ON;
    blueLed     = LED_OFF;

    oled.DrawImage(image1,0,0);
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);
    
    /* Set text properties to white and right aligned for the dynamic text */
    textProperties.fontColor = COLOR_YELLOW;
    textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
    oled.SetTextProperties(&textProperties);
    /* Display text2 */
    strcpy((char *) text1,"When green LED");
    oled.Label((uint8_t *)text1,3,28);
    /* Display text3 */
    strcpy((char *) text2,"turns off, press"); //17 characters max length per statement
    oled.Label((uint8_t *)text2,3,41);
    /* Display text4 */
    strcpy((char *) text3,"another button");
    oled.Label((uint8_t *)text3,3,54);
    /* Display text5 */
    strcpy((char *) text4,"to play");
    oled.Label((uint8_t *)text4,3,67);
    /* Register callbacks to application functions */
    strcpy((char *)text5,"another song");
    oled.Label((uint8_t *)text5,3,80);

    for(i=0; i<tones_num3; i++) 
    {
        Auto_tunes(Buzzer, tones2a[i], 4); // Auto performance
        Stop_tunes(Buzzer);
    }  
    Tune(Buzzer, C_5, 8);  //4 Octave C beat 4/16
    wait_ms(25);
    Tune(Buzzer, Ds_5, 8);  //4 Octave C beat 4/16
    wait_ms(25);
    Tune(Buzzer, As_4, 8);  //4 Octave C beat 4/16
    wait_ms(25);
    Tune(Buzzer, C_5, 20);
    wait_ms(250);
    
    for(i=0; i<tones_num3; i++) 
    {
        Auto_tunes(Buzzer, tones2a[i], 4); // Auto performance
        Stop_tunes(Buzzer);
    }  
    Tune(Buzzer, C_5, 8);  //4 Octave C beat 4/16
    wait_ms(25);
    Tune(Buzzer, Ds_5, 8);  //4 Octave C beat 4/16
    wait_ms(25);
    Tune(Buzzer, As_4, 8);  //4 Octave C beat 4/16
    wait_ms(25);
    Tune(Buzzer, C_5, 20);
    wait_ms(250);
    
    for(i=0; i<tones_num3; i++) 
    {
        Auto_tunes(Buzzer, tones2a[i], 4); // Auto performance
        Stop_tunes(Buzzer);
    }  
    Tune(Buzzer, C_5, 8);  //4 Octave C beat 4/16
    wait_ms(25);
    Tune(Buzzer, Ds_5, 8);  //4 Octave C beat 4/16
    wait_ms(25);
    Tune(Buzzer, As_4, 8);  //4 Octave C beat 4/16
    wait_ms(25);
    Tune(Buzzer, C_5, 20);
    wait_ms(250);
    
    for(i=0; i<tones_num4; i++) 
    {
        Auto_tunes(Buzzer, tones2b[i], 8); // Auto performance
        Stop_tunes(Buzzer);
    }
    Tune(Buzzer, Ds_5, 12);  //4 Octave C beat 4/16
    wait_ms(250); 
    
    for(i=0; i<tones_num4; i++) 
    {
        Auto_tunes(Buzzer, tones2b[i], 8); // Auto performance
        Stop_tunes(Buzzer);
    }
    Tune(Buzzer, Ds_5, 12);  //4 Octave C beat 4/16
    wait_ms(250);
    
    for(i=0; i<tones_num4; i++) 
    {
        Auto_tunes(Buzzer, tones2b[i], 8); // Auto performance
        Stop_tunes(Buzzer);
    }
    Tune(Buzzer, Ds_5, 12);  //4 Octave C beat 4/16
    wait_ms(250);
    
    for(i=0; i<tones_num4; i++) 
    {
        Auto_tunes(Buzzer, tones2c[i], 8); // Auto performance
        Stop_tunes(Buzzer);
    }
    Tune(Buzzer, C_5, 12);  //4 Octave C beat 4/16
    wait_ms(250);
    
    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;
}
//-------------------------BLUE LED---------------------------------------------
void ButtonDown(void)
{
    StartHaptic();

    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    blueLed     = LED_ON;

    oled.DrawImage(image1,0,0);
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);
    
    /* Set text properties to white and right aligned for the dynamic text */
    textProperties.fontColor = COLOR_YELLOW;
    textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
    oled.SetTextProperties(&textProperties);
    /* Display text2 */
    strcpy((char *) text1,"When blue LED");
    oled.Label((uint8_t *)text1,3,28);
    /* Display text3 */
    strcpy((char *) text2,"turns off, press"); //17 characters max length per statement
    oled.Label((uint8_t *)text2,3,41);
    /* Display text4 */
    strcpy((char *) text3,"another button");
    oled.Label((uint8_t *)text3,3,54);
    /* Display text5 */
    strcpy((char *) text4,"to play");
    oled.Label((uint8_t *)text4,3,67);
    /* Register callbacks to application functions */
    strcpy((char *)text5,"another song");
    oled.Label((uint8_t *)text5,3,80);

    Tune(Buzzer, 0, 4);    //1
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //2 
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //3 
    wait_ms(25);
    Tune(Buzzer, A_5, 4);  //4 
    wait_ms(25);
    Tune(Buzzer, G_5, 24); //5  
    wait_ms(25);
    Tune(Buzzer, A_5, 2);  //6
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //7
    wait_ms(25);
    Tune(Buzzer, A_5, 2);  //8
    wait_ms(25);
    Tune(Buzzer, G_5, 24); //9 
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //10
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //11
    wait_ms(25);
    Tune(Buzzer, C_6, 4);  //12
    wait_ms(25);
    Tune(Buzzer, B_5, 24); //13
    wait_ms(25);
    Tune(Buzzer, A_5, 2);  //14
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //15
    wait_ms(25);
    Tune(Buzzer, A_5, 6);  //16
    wait_ms(25);
    Tune(Buzzer, G_5, 18); //17
    wait_ms(25);
    Tune(Buzzer, G_5, 3);  //18
    wait_ms(25);
    Tune(Buzzer, A_5, 3);  //19
    wait_ms(25);
    Tune(Buzzer, G_5, 3);  //20
    wait_ms(25);
    Tune(Buzzer, D_6, 4);  //21
    wait_ms(25);
    Tune(Buzzer, Fs_6, 2); //22
    wait_ms(25);
    Tune(Buzzer, B_5, 10); //23
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //24
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //25
    wait_ms(25);
    Tune(Buzzer, A_5, 2);  //26
    wait_ms(25);
    Tune(Buzzer, G_5, 4);  //27
    wait_ms(25);
    Tune(Buzzer, C_6, 3);  //28
    wait_ms(25);
    Tune(Buzzer, E_5, 22); //29
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //30
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //31
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //32
    wait_ms(25);
    Tune(Buzzer, A_5, 2);  //33
    wait_ms(25);
    Tune(Buzzer, G_5, 4);  //34
    wait_ms(25);
    Tune(Buzzer, C_6, 4);  //35
    wait_ms(25);
    Tune(Buzzer, B_6, 10); //36
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //37
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //38
    wait_ms(25);
    Tune(Buzzer, G_5, 2);  //39
    wait_ms(25);
    Tune(Buzzer, G_5, 3);  //40
    wait_ms(25);
    Tune(Buzzer, A_5, 3);  //41
    wait_ms(25);
    Tune(Buzzer, G_5, 3);  //42
    wait_ms(25);
    Tune(Buzzer, A_5, 5);  //43
    wait_ms(25);
    Tune(Buzzer, G_5, 14); //44
    wait_ms(25);
    Tune(Buzzer, G_4, 2);  //45
    wait_ms(25);
    Tune(Buzzer, B_4, 4);  //46
    wait_ms(25);
    Tune(Buzzer, A_4, 4);  //47
    wait_ms(25);
    Tune(Buzzer, G_4, 4);  //48
    wait_ms(25);
    Tune(Buzzer, G_4, 4);  //49
    wait_ms(25);
    Tune(Buzzer, B_4, 2);  //50
    wait_ms(25);
    Tune(Buzzer, A_4, 4);  //51
    wait_ms(25);
    Tune(Buzzer, G_4, 6);  //52
    wait_ms(25);
    Tune(Buzzer, G_4, 2);  //53
    wait_ms(25);
    Tune(Buzzer, B_4, 2);  //54
    wait_ms(25);
    Tune(Buzzer, A_4, 4);  //55
    wait_ms(25);
    Tune(Buzzer, G_4, 6);  //56
    wait_ms(25);
    Tune(Buzzer, G_4, 2);  //57
    wait_ms(25);
    Tune(Buzzer, C_5, 4);  //58
    wait_ms(25);
    Tune(Buzzer, B_4, 4);  //59
    wait_ms(25);
    Tune(Buzzer, G_4, 4);  //60
    wait_ms(25);
    Tune(Buzzer, Fs_4, 6); //61
    wait_ms(25);
    Tune(Buzzer, G_4, 2);  //62
    wait_ms(25); 
    Tune(Buzzer, B_5, 4);  //63
    wait_ms(25); 
    Tune(Buzzer, B_4, 6);  //64
    wait_ms(25); 
    Tune(Buzzer, G_4, 4);  //65
    wait_ms(25); 
    Tune(Buzzer, C_5, 4);  //66
    wait_ms(25); 
    Tune(Buzzer, B_4, 2);  //67
    wait_ms(25); 
    Tune(Buzzer, B_4, 10); //68
    wait_ms(25); 
    Tune(Buzzer, A_4, 2);  //69
    wait_ms(25); 
    Tune(Buzzer, A_4, 4);  //70
    wait_ms(25); 
    Tune(Buzzer, A_4, 4);  //71
    wait_ms(25); 
    Tune(Buzzer, A_4, 6);  //72
    wait_ms(25); 
    Tune(Buzzer, A_4, 4);  //73
    wait_ms(25); 
    Tune(Buzzer, G_4, 4);  //74
    wait_ms(25); 
    Tune(Buzzer, A_4, 4);  //75
    wait_ms(25); 
    Tune(Buzzer, B_4, 4);  //76
    wait_ms(25); 
    Tune(Buzzer, A_4, 4);  //77
    wait_ms(25); 
    Tune(Buzzer, G_4, 4);  //78
    wait_ms(25); 
    Tune(Buzzer, G_4, 8);  //79
    wait_ms(25); 
    Tune(Buzzer, G_4, 8);  //80
    wait_ms(25); 
    Tune(Buzzer, 0, 4);    //81
    wait_ms(25); 
    Tune(Buzzer, B_4, 4);  //82
    wait_ms(25); 
    Tune(Buzzer, A_4, 4);  //83
    wait_ms(25); 
    Tune(Buzzer, G_4, 2);  //84
    wait_ms(25); 
    Tune(Buzzer, A_4, 2);  //85
    wait_ms(25);
    Tune(Buzzer, A_4, 8);  //86
    wait_ms(25); 
    Tune(Buzzer, A_4, 8);  //87
    wait_ms(25); 
    Tune(Buzzer, 0, 4);    //88
    wait_ms(25); 
    Tune(Buzzer, C_5, 4);  //89
    wait_ms(25); 
    Tune(Buzzer, B_4, 4);  //90
    wait_ms(25); 
    Tune(Buzzer, A_4, 2);  //91
    wait_ms(25); 
    Tune(Buzzer, B_4, 2);  //92
    wait_ms(25); 
    Tune(Buzzer, B_4, 8);  //93
    wait_ms(25); 
    Tune(Buzzer, B_4, 8);  //94
    wait_ms(25); 
    Tune(Buzzer, Fs_4, 8); //95
    wait_ms(25); 
    Tune(Buzzer, G_4, 4);  //96 
    wait_ms(25); 
    Tune(Buzzer, C_4, 20); //97
    wait_ms(25); 
    Tune(Buzzer, 0, 4);    //98
    wait_ms(25); 
    Tune(Buzzer, B_4, 4);  //99
    wait_ms(25); 
    Tune(Buzzer, A_4, 4);  //100
    wait_ms(25); 
    Tune(Buzzer, G_4, 4);  //101
    wait_ms(25); 
    Tune(Buzzer, G_4, 8);  //102
    wait_ms(25); 
    Tune(Buzzer, G_4, 8);  //103
    wait_ms(25); 
    Tune(Buzzer, G_4, 2);  //104
    wait_ms(25); 
    Tune(Buzzer, A_4, 2);  //105
    wait_ms(25); 
    Tune(Buzzer, B_4, 4);  //106
    wait_ms(25); 
    Tune(Buzzer, A_4, 4);  //107
    wait_ms(25); 
    Tune(Buzzer, G_4, 2);  //108
    wait_ms(25); 
    Tune(Buzzer, A_4, 2);  //109
    wait_ms(25); 
    Tune(Buzzer, A_4, 8);  //110
    wait_ms(25); 
    Tune(Buzzer, A_4, 8);  //111
    wait_ms(25); 
    Tune(Buzzer, 0, 4);    //112
    wait_ms(25); 
    Tune(Buzzer, B_4, 4);  //113
    wait_ms(25); 
    Tune(Buzzer, B_4, 4);  //114
    wait_ms(25); 
    Tune(Buzzer, A_4, 2);  //115
    wait_ms(25); 
    Tune(Buzzer, B_4, 2);  //116
    wait_ms(25); 
    Tune(Buzzer, B_4, 8);  //117
    wait_ms(25); 
    Tune(Buzzer, B_4, 8);  //118
    wait_ms(25); 
    Tune(Buzzer, A_4, 8);  //119
    wait_ms(25); 
    Tune(Buzzer, G_4, 4);  //120
    wait_ms(25); 
    Tune(Buzzer, G_4, 2);  //121
    wait_ms(25); 
    Tune(Buzzer, G_4, 2);  //122  
    wait_ms(25); 
    Tune(Buzzer, D_5, 4);  //123
    wait_ms(25);  
    Tune(Buzzer, D_4, 2);  //124
    wait_ms(25);  
    Tune(Buzzer, D_4, 2);  //125
    wait_ms(25);  
    Tune(Buzzer, B_4, 4);  //126
    wait_ms(25);  
    Tune(Buzzer, G_4, 2);  //127
    wait_ms(25);  
    Tune(Buzzer, D_5, 4);  //128
    wait_ms(25);  
    Tune(Buzzer, D_5, 4);  //129
    wait_ms(25);  
    Tune(Buzzer, D_5, 2);  //130
    wait_ms(25);  
    Tune(Buzzer, B_4, 6);  //131
    wait_ms(25);  
    Tune(Buzzer, G_4, 2);    //132
    wait_ms(25);  
    Tune(Buzzer, B_4, 16);  //133
    wait_ms(25);  
    Tune(Buzzer, A_4, 14);  //134
    wait_ms(25);  
    Tune(Buzzer, G_4, 2);  //135
    wait_ms(25);  
    Tune(Buzzer, A_4, 4);  //136
    wait_ms(25);  
    Tune(Buzzer, A_4, 4);  //137
    wait_ms(25);  
    Tune(Buzzer, A_4, 6);  //138
    wait_ms(25);  
    Tune(Buzzer, G_4, 2);  //139
    wait_ms(25);  
    Tune(Buzzer, A_4, 2);  //140
    wait_ms(25);  
    Tune(Buzzer, G_4, 2);  //141
    wait_ms(25);  
    Tune(Buzzer, B_4, 4);  //142
    wait_ms(25);  
    Tune(Buzzer, B_4, 4);  //143
    wait_ms(25);  
    Tune(Buzzer, G_4, 4);  //144
    wait_ms(25);  
    Tune(Buzzer, G_4, 32);  //145
    wait_ms(25);  
    Tune(Buzzer, D_4, 10);  //146
    wait_ms(25);  
    Tune(Buzzer, D_4, 8);  //147
    wait_ms(25);  
    
    
        
    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;
}
//-------------------------Yellow LED-------------------------------------------
void ButtonUp(void)
{
    StartHaptic();

    redLed      = LED_ON;
    greenLed    = LED_ON;
    blueLed     = LED_OFF;

    oled.DrawImage(image1,0,0);
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);
    
        /* Set text properties to white and right aligned for the dynamic text */
        textProperties.fontColor = COLOR_YELLOW;
        textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
        oled.SetTextProperties(&textProperties);
        /* Display text2 */
        strcpy((char *) text1,"When yellow LED");
        oled.Label((uint8_t *)text1,3,28);
        /* Display text3 */
        strcpy((char *) text2,"turns off, press"); //17 characters max length per statement
        oled.Label((uint8_t *)text2,3,41);
        /* Display text4 */
        strcpy((char *) text3,"another button");
        oled.Label((uint8_t *)text3,3,54);
        /* Display text5 */
        strcpy((char *) text4,"to play");
        oled.Label((uint8_t *)text4,3,67);
        /* Register callbacks to application functions */
        strcpy((char *)text5,"another song");
        oled.Label((uint8_t *)text5,3,80);

    for(i=0; i<tones_num2; i++) 
    {
        Auto_tunes(Buzzer, tones4[i], 4); // Auto performance
        Stop_tunes(Buzzer);
    }
    Tune(Buzzer, A_4, 8);  //4 Octave F beat 4/16
    Tune(Buzzer, F_4, 16);  //4 Octave F beat 4/16
    wait_ms(250);
    
    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;
}


/*------------------MAIN------------------------------------------------------*/

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)

int main()
{
    while(true)
    {
        // Setting pointer location of the 96 by 96 pixel bitmap
        image1  = Accelero;
        // Fill 96px by 96px Screen with 96px by 96px NXP Image starting at x=0,y=0
        oled.DrawImage(image1,0,0);
        
        redLed = LED_ON;
        greenLed = LED_OFF;
        blueLed = LED_OFF;
        wait(1);
        
        redLed = LED_OFF;
        greenLed = LED_ON;
        blueLed = LED_OFF;
        wait(1);
        
        redLed = LED_OFF;
        greenLed = LED_OFF;
        blueLed = LED_ON;
        wait(1);
        
        oled_text_properties_t textProperties = {0};
        oled.GetTextProperties(&textProperties);
        /* Set text properties to white and right aligned for the dynamic text */
        textProperties.fontColor = COLOR_YELLOW;
        textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
        oled.SetTextProperties(&textProperties);
        /* Display text2 */
        strcpy((char *) text1,"Hello! Press the ");
        oled.Label((uint8_t *)text1,3,28);
        /* Display text3 */
        strcpy((char *) text2,"the left, right, "); //17 characters max length per statement
        oled.Label((uint8_t *)text2,3,41);
        /* Display text4 */
        strcpy((char *) text3,"top, or bottom   ");
        oled.Label((uint8_t *)text3,3,54);
        /* Display text5 */
        strcpy((char *) text4,"buttons to play  ");
        oled.Label((uint8_t *)text4,3,67);
        /* Register callbacks to application functions */
        strcpy((char *)text5,"a song            ");
        oled.Label((uint8_t *)text5,3,80);
        
        kw40z_device.attach_buttonUp(&ButtonUp);
        kw40z_device.attach_buttonDown(&ButtonDown);
        kw40z_device.attach_buttonLeft(&ButtonLeft);
        kw40z_device.attach_buttonRight(&ButtonRight);
        while(true){
        Thread::wait(500);}
    }
}

void StartHaptic(void)
{
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n)
{
    haptic = 0;
    hapticTimer.stop();
}
