#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h"

Serial pc(USBTX, USBRX);

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

TSIAnalogSlider tsi(ELEC0, ELEC1, 40);//DECLARO TSI

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);//DECLARO ACELEROMETRO

Ticker ti;//DECLARO EL TIMER 1

DigitalOut LV(LED2);
AnalogIn ANALOGICA(A2);
DigitalIn ENTRADA (PTB10);

//DECLARO MAQUINAS DE ESTADOS
void ME_SERIE_RECIBO(void);
void ME_SERIE_ENVIO(void);
void ME_LED_SERIE_ON(void);
void ME_LED_SERIE_OFF(void);

//DECLARO FUNCIONES
void TSII(void);//FUNCION TSI
void ANALOGICO(void);//FUNCION DE LA ENTRADA ANALOGICA
void ACELEROMETRO(void);//FUNCION ACELEROMETRO
void tiempo(void);//FUNCION DEL TIMER

//bit usado como flag para procesar datos
bool newdata = false;

//VARIABLES DEL SERIE RECIBO
char c = '\0';

//Callback cuando se detecta una entrada
void onCharReceived()
{
    //Copiamos lo leido en c
    c = pc.getc();
    newdata = true;
}

//VARIABLES DE SERIE RECIBO
int e_serie_recibo=0;
bool ok=0, recibo_A=0, recibo_$=0, recibo_V=0, recibo_D=0, recibo_1=0, recibo_X=0, recibo_Y=0, recibo_Z=0;

//VARIABLES DE SERIE ENVIO
int e_serie_envio=0;

// VARIABLES DE LED SERIE ON
bool e_led_serie_on=0;

// VARIABLES DE LED SERIE ON
bool e_led_serie_off=0;

// VARIABLES DEL TSII
float j=0;
bool inicio=0;

// VARIABLES DE LA ENTRADA ANALOGICA
int analog=0;
int analog_previa=0;
int analog_unidad=0, analog_decena=0;
int analog_unidad_ascii=0, analog_decena_ascii=0;
int analog_unidad_xor=0, analog_decena_xor=0;

// VARIABLES DEL ACELEROMETRO
float x=0, y=0, z=0;
int x_previa=0, y_previa=0, z_previa=0;
int x_unidad=0, x_decena=0, y_unidad=0, y_decena=0, z_unidad=0, z_decena=0;
int unidad_x_ascii=0, decena_x_ascii=0, unidad_y_ascii=0, decena_y_ascii=0, unidad_z_ascii=0, decena_z_ascii=0;
int xor_x_decena=0, xor_y_decena=0, xor_z_decena=0, xor_x_unidad=0, xor_y_unidad=0, xor_z_unidad=0;

// VARIABLES DEL TIMER
int t_tsii=0;
int t_led_serie_on=0;
int t_led_serie_off=0;
int main()
{
    pc.attach(&onCharReceived);
    LV=1;
    ti.attach(&tiempo,0.05);
    while(1) {
        TSII();
        if(inicio==1) {
            ME_SERIE_RECIBO();
            ME_SERIE_ENVIO();
            ME_LED_SERIE_ON();
        } else {
            ME_LED_SERIE_OFF();
        }
    }
}

void ME_SERIE_RECIBO(void)
{
    if (newdata) {
        newdata=false;
        switch(e_serie_recibo) {
            default:
                e_serie_recibo=0;
                break;
            case 0:
                if(c=='$') {
                    e_serie_recibo=1;
                    recibo_$=1;
                    break;
                } else {
                    printf("\n error de codigo\r\n");
                    ok=0;
                    recibo_$=0;
                    recibo_A=0;
                    recibo_V=0;
                    recibo_D=0;
                    recibo_1=0;
                    recibo_X=0;
                    recibo_Y=0;
                    recibo_Z=0;
                    e_serie_recibo=0;

                }
                break;
            case 1:
                if (c=='A') {
                    recibo_A=1;
                    e_serie_recibo=2;
                    break;
                } else if(c=='V') {
                    recibo_V=1;
                    e_serie_recibo=2;
                    break;
                } else if(c=='D') {
                    recibo_D=1;
                    e_serie_recibo=2;
                    break;
                } else {
                    printf("\n error de codigo\r\n");
                    ok=0;
                    recibo_$=0;
                    recibo_A=0;
                    recibo_V=0;
                    recibo_D=0;
                    recibo_1=0;
                    recibo_X=0;
                    recibo_Y=0;
                    recibo_Z=0;
                    e_serie_recibo=0;
                }
                break;
            case 2:
                if(c=='X') {
                    recibo_X=1;
                    e_serie_recibo=3;
                    break;
                } else if(c=='Y') {
                    recibo_Y=1;
                    e_serie_recibo=3;
                    break;
                } else if(c=='Z') {
                    recibo_Z=1;
                    e_serie_recibo=3;
                    break;
                } else if(c=='1') {
                    recibo_1=1;
                    e_serie_recibo=3;
                    break;
                } else {
                    printf("\n error de codigo\r\n");
                    ok=0;
                    recibo_$=0;
                    recibo_A=0;
                    recibo_V=0;
                    recibo_D=0;
                    recibo_1=0;
                    recibo_X=0;
                    recibo_Y=0;
                    recibo_Z=0;
                    e_serie_recibo=0;
                }
                break;
            case 3:
                if(c=='%') {
                    ok=1;
                    e_serie_recibo=0;
                } else {
                    printf("\n error de codigo\r\n");
                    ok=0;
                    recibo_$=0;
                    recibo_A=0;
                    recibo_V=0;
                    recibo_D=0;
                    recibo_1=0;
                    recibo_X=0;
                    recibo_Y=0;
                    recibo_Z=0;
                    e_serie_recibo=0;
                }
                break;
        }

    }
}

void ME_SERIE_ENVIO(void)
{
    if(ok==1) {
        switch(e_serie_envio) {
            default:
                e_serie_envio=0;
            case 0:
                if(recibo_$==1) {
                    recibo_$=0;
                    e_serie_envio=1;
                    break;
                }
                break;
            case 1:
                if(recibo_A==1) {
                    recibo_A=0;
                    e_serie_envio=2;
                    break;
                } else if(recibo_V==1) {
                    recibo_V=0;
                    e_serie_envio=3;
                    break;
                } else if(recibo_D==1) {
                    recibo_D=0;
                    e_serie_envio=4;
                }
                break;
            case 2:
                if(recibo_X==1) {
                    ACELEROMETRO();
                    printf("\n $AX%d%d%x%% \r\n",x_decena,x_unidad,xor_x_unidad);
                    ok=0;
                    recibo_$=0;
                    recibo_A=0;
                    recibo_V=0;
                    recibo_D=0;
                    recibo_1=0;
                    recibo_X=0;
                    recibo_Y=0;
                    recibo_Z=0;
                    e_serie_envio=0;
                    break;
                } else if (recibo_Y==1) {
                    ACELEROMETRO();
                    printf("\n $AY%d%d%x%% \r\n",y_decena,y_unidad,xor_y_unidad);
                    ok=0;
                    recibo_$=0;
                    recibo_A=0;
                    recibo_V=0;
                    recibo_D=0;
                    recibo_1=0;
                    recibo_X=0;
                    recibo_Y=0;
                    recibo_Z=0;
                    e_serie_envio=0;
                    break;
                } else if(recibo_Z==1) {
                    ACELEROMETRO();
                    printf("\n $AZ%d%d%x%% \r\n",z_decena,z_unidad,xor_z_unidad);
                    ok=0;
                    recibo_$=0;
                    recibo_A=0;
                    recibo_V=0;
                    recibo_D=0;
                    recibo_1=0;
                    recibo_X=0;
                    recibo_Y=0;
                    recibo_Z=0;
                    e_serie_envio=0;
                }
                break;
            case 3:
                if(recibo_1==1) {
                    ANALOGICO();
                    printf("\n $V1%d%d%x%% \r\n",analog_decena,analog_unidad,analog_unidad_xor);
                    ok=0;
                    recibo_$=0;
                    recibo_A=0;
                    recibo_V=0;
                    recibo_D=0;
                    recibo_1=0;
                    recibo_X=0;
                    recibo_Y=0;
                    recibo_Z=0;
                    e_serie_envio=0;
                }
                break;
            case 4:
                if(recibo_1==1) {
                    if(ENTRADA==1) {
                        printf("\n $D10174%% \r\n");
                        ok=0;
                        recibo_$=0;
                        recibo_A=0;
                        recibo_V=0;
                        recibo_D=0;
                        recibo_1=0;
                        recibo_X=0;
                        recibo_Y=0;
                        recibo_Z=0;
                        e_serie_envio=0;
                        break;
                    } else {
                        printf("\n $D10075%% \r\n");
                        ok=0;
                        recibo_$=0;
                        recibo_A=0;
                        recibo_V=0;
                        recibo_D=0;
                        recibo_1=0;
                        recibo_X=0;
                        recibo_Y=0;
                        recibo_Z=0;
                        e_serie_envio=0;
                        break;
                    }
                }
                break;
        }
    }
}

void ME_LED_SERIE_ON(void)
{
    if(inicio==1) {
        switch(e_led_serie_on) {
            case 0:
                LV=0;
                if(t_led_serie_on>=3 && LV==0) {
                    t_led_serie_on=0;
                    e_led_serie_on=1;
                }
                break;
            case 1:
                LV=1;
                if(t_led_serie_on>=10 && LV==1) {
                    t_led_serie_on=0;
                    e_led_serie_on=0;
                }
                break;
        }
    }
}

void ME_LED_SERIE_OFF(void)
{
    if(inicio==0) {
        switch(e_led_serie_off) {
            case 0:
                LV=0;
                if(t_led_serie_off>=5 && LV==0) {
                    t_led_serie_off=0;
                    e_led_serie_off=1;
                }
                break;
            case 1:
                LV=1;
                if(t_led_serie_off>=5 && LV==1) {
                    t_led_serie_off=0;
                    e_led_serie_off=0;
                }
                break;
        }
    }
}

void TSII(void)
{
    j=tsi.readPercentage();
    if(j>0.01 && t_tsii==0) {
        inicio=!inicio;
        t_tsii=3;
    }
}

void ANALOGICO(void)
{
    analog=ANALOGICA.read_u16();
    //USO REGLA DE 3
    analog_previa=(analog*33)/65536;
    //DIVIDO UNIADADES Y DECENAS
    analog_decena=analog_previa/10;
    analog_unidad=analog_previa-(analog_decena*10);
    //PASO A ASCII
    analog_decena_ascii=analog_decena+48;
    analog_unidad_ascii=analog_unidad+48;
    //PASO A XOR PARA VERIFICACION
    analog_decena_xor = analog_decena_ascii ^ 103;
    analog_unidad_xor = analog_decena_xor ^ analog_unidad_ascii;

}

void ACELEROMETRO(void)
{
    x = abs(acc.getAccX());
    y = abs(acc.getAccY());
    z = abs(acc.getAccZ());

    x_previa= x*10;
    //DIVIDO UNIADADES Y DECENAS
    x_decena=x_previa/10;
    x_unidad=x_previa-(x_decena*10);
    //PASO A ASCII
    decena_x_ascii= x_decena+48;
    unidad_x_ascii= x_unidad+48;
    //PASO A XOR PARA VERIFICACION
    xor_x_decena= 25 ^ decena_x_ascii;
    xor_x_unidad=xor_x_decena ^ unidad_x_ascii;

    y_previa= y*10;
    //DIVIDO UNIADADES Y DECENAS
    y_decena=y_previa/10;
    y_unidad=y_previa-(y_decena*10);
    //PASO A ASCII
    decena_y_ascii= y_decena+48;
    unidad_y_ascii= y_unidad+48;
    //PASO A XOR PARA VERIFICACION
    xor_y_decena= 24 ^ decena_y_ascii;
    xor_y_unidad=xor_y_decena ^ unidad_y_ascii;

    z_previa= z*10;
    //DIVIDO UNIADADES Y DECENAS
    z_decena=z_previa/10;
    z_unidad=z_previa-(z_decena*10);
    //PASO A ASCII
    decena_z_ascii= z_decena+48;
    unidad_z_ascii= z_unidad+48;
    //PASO A XOR PARA VERIFICACION
    xor_z_decena = 27 ^ decena_z_ascii;
    xor_z_unidad = xor_z_decena ^ unidad_z_ascii;

}

void tiempo(void)
{
    t_led_serie_off++;
    t_led_serie_on++;
    t_tsii--;
    if(t_tsii <=0) {
        t_tsii=0;
    }
}
