#include "mbed.h"
#include "MIDI_sub3.h"

int main(){
    int i, j, k, p;
    unsigned char adc_new;
    i = j = k = p = 0;
    rx_top = rx_end = tx_top = tx_end = adc_no = 0; 
    MIDI.baud(31250);
    MIDI.attach(&rx_fifoset, MIDI.RxIrq);
    LatchPulse.write(0x01F8);
    TriggerOut.write(0xF000);
    trigger_status = 0;
    for(i=0; i<6; i++) DAC_out(i,0);
    for(i=0; i<10; i++) adc_old[i] = 0;
    while(1){
        if(++p > 10000){
            p = 0;
            if(++adc_no > 9) adc_no = 0;
            adc_new = ADC_get(adc_no);
            if(adc_old[adc_no] != adc_new){
                adc_old[adc_no] = adc_new;
                tx_fifoset(0xBF);
                tx_fifoset(adc_no);
                tx_fifoset(adc_new);
            }
        }
        tx_fifo_check();
        if(rx_fifo_check() == 1){
            switch(midi_message>>20){
                case 0x0B:
                    if(((midi_message>>16) & 0x0F) == 0){
                        k = (midi_message>>8) & 0x7F;
                        if(k < 6){
                            DAC_out(k, (midi_message & 0x7F)<<1);
                        }
                    }
                    else if(((midi_message>>16) & 0x0F) == 1){
                        k = (midi_message>>8) & 0x7F;
                        if(k < 4){
                            Trigger_send(k, (midi_message & 0x7F));
                        }
                    }
                    break;
                case 0x0C:
                    tx_fifoset(midi_message>>16);
                    tx_fifoset((midi_message>>8) & 0x7F);
                    break;
            }         
        }
        if(++j > 1000000){
            j = 0;
            myled = !myled;
        }
    }
}