unsigned char rxFIFO[256], txFIFO[256], adc_old[10], trigger_status;
unsigned char rx_top, rx_end, tx_top, tx_end, status, keyno, dcb;
int midi_message, adc_no;

RawSerial MIDI(PA_2, PA_3);
DigitalOut myled(LED1);
PortOut DataBus(PortA, 0x1FE0); // PA_12 --- PA_5
PortOut LatchPulse(PortB, 0x01F8); // PB_8 --- PB_3
PortOut TriggerOut(PortB, 0xF000); // PB_15 --- PB_12
AnalogIn analog_value1(PA_0);
AnalogIn analog_value2(PA_1);
AnalogIn analog_value3(PA_4);
AnalogIn analog_value4(PB_0);
AnalogIn analog_value5(PC_1);
AnalogIn analog_value6(PC_0);
AnalogIn analog_value7(PC_2);
AnalogIn analog_value8(PC_3);
AnalogIn analog_value9(PC_4);
AnalogIn analog_value10(PB_1);

void Trigger_send(int address, int data){
    unsigned char mask;
    mask = 0x01 << address;
    trigger_status &= (~mask);
    if(data == 0){
        trigger_status += mask;        
    }
    TriggerOut.write((trigger_status & 0x0F) << 12);
    return;
}

unsigned char ADC_get(int num){
    unsigned short data = 0;
    switch(num){
        case(0):
            data = analog_value1.read_u16();
            break;
        case(1):
            data = analog_value2.read_u16();
            break;
        case(2):
            data = analog_value3.read_u16();
            break;
        case(3):
            data = analog_value4.read_u16();
            break;
        case(4):
            data = analog_value5.read_u16();
            break;
        case(5):
            data = analog_value6.read_u16();
            break;
        case(6):
            data = analog_value7.read_u16();
            break;
        case(7):
            data = analog_value8.read_u16();
            break;
        case(8):
            data = analog_value9.read_u16();
            break;
        case(9):
            data = analog_value10.read_u16();
            break;
    }
    return(data>>9);
}
    
void DAC_out(int address, int data){
    DataBus.write(data<<5);
    switch(address){
        case(0):
            LatchPulse.write(0x01F0);
            break;
        case(1):
            LatchPulse.write(0x01E8);
            break;
        case(2):
            LatchPulse.write(0x01D8);
            break;
        case(3):
            LatchPulse.write(0x01B8);
            break;
        case(4):
            LatchPulse.write(0x0178);
            break;
        case(5):
            LatchPulse.write(0x00F8);
            break;
        default:
            break;
    }
    LatchPulse.write(0x01F8);
    return;
}

int rx_fifo_check(void){
    unsigned char data;
    if(rx_top != rx_end){
        data = rxFIFO[rx_end];
        ++rx_end &= 255;
        if (data > 127){
            status = data;
            dcb = 0;
            return(0);
        }
        else if(status > 0xEF){
            return(0);
        }
        else if( (status > 0xBF) && (status < 0xE0) ){
            midi_message = (status<<16) + (data<<8);
            dcb = 0;
            return(1);
        }
        else if(dcb==0){
            keyno = data;
            dcb++;
            return(0);
        }
        else{
            midi_message = (status<<16) + (keyno<<8) + data;
            dcb = 0;
            return(1);
        }
    }
    return(0);
}

void rx_fifoset(void){
    rxFIFO[rx_top] = MIDI.getc();
    ++rx_top &= 255;
    return;
}

void tx_fifo_check(void){
    if(MIDI.writeable() == 1){
        if(tx_top != tx_end){
            MIDI.putc(txFIFO[tx_end]);
            ++tx_end &= 255;
        }
    }
    return;
}

void tx_fifoset(unsigned char data){
    txFIFO[tx_top] = data;
    ++tx_top &= 255;
    return;
}
