#include "mbed.h"
#include "sub.hpp"
#include "notch.hpp"
#include "fft1.hpp"

float in1[16], out1[16], in2[16], out2[16];
        
int main(){
    common_setup();
    int fft_counter1 = 0;
    int fft_counter2 = 0;
    xbee.baud(38400);
    xbee.attach(&rx_fifoset, xbee.RxIrq);
    timer_setup.attach_us(&timer_interrupt, 5); // 5usec
    while(1){
        tx_fifo_check();
        if(timer_value[1] > 19){ // 0.1msec sampling
            timer_value[1] = 0;
            data1 = (float)gain * (analog_value2.read() - 0.5f);  // A/D in (3)
            data2 = (float)gain * (analog_value3.read() - 0.5f);  // A/D in (4)
            if(data1 < 0) data1 = -data1; // always detection ON
            if(notch_1 != 0) data1 = notch_filter1(data1);
            if(max_count != 0) data1 = move_mean_calc1(data1);
            if(data2 < 0) data2 = -data2; // always detection ON
            if(notch_2 != 0) data2 = notch_filter2(data2);
            if(max_count != 0) data2 = move_mean_calc2(data2);
        }
        if(timer_value[2] > 199){ // 1msec sampling
            timer_value[2] = 0;
            in1[fft_counter1] = data1;            
            if(++fft_counter1 > 15){
                fft_counter1 = 0;
                fft1(in1, out1);
                int summ = 0;
                for(int i=0; i<7; i++) { summ = summ + (uint16_t)((out1[2*i]+out1[2*i+1]) * 7.9) << ((6-i)*3); }
                tx_message(0x000000 + summ);
            }
        }
        if(timer_value[3] > 199){ // 1msec sampling
            timer_value[3] = 0;         
            in2[fft_counter2] = data2;
            if(++fft_counter2 > 15){
                fft_counter2 = 0;
                fft1(in2, out2);
                int summ = 0;
                for(int i=0; i<7; i++) { summ = summ + (uint16_t)((out2[2*i]+out2[2*i+1]) * 7.9) << ((6-i)*3); }
                tx_message(0x400000 + summ);
            }
        }
        if(timer_value[0] > 199999){ // 1000msec
            timer_value[0] = 0;
            myled = !myled;
        }
        if(rx_fifo_check() == 1){
            int sum = 0;
            for (int i=0; i<6; i++) sum += conv_hex(raw_data[i])<<(4*(5-i));
            tx_message(sum); // Echo Back 
            if(sum>>16 == 0x80){
                switch((sum & 0xff00)>>8){
                    case 0x00:
                        break;
                    case 0x01:
                        gain = sum & 0x0f;
                        break;
                    case 0x02:
                        max_count = sum & 0x7f;
                        if (max_count>100) max_count = 100;
                        sum_clear();
                        break;
                    case 0x03:
                        notch_1 = sum & 0x01;
                        break;
                    case 0x04:
                        notch_2 = sum & 0x01;
                        break;
                    case 0x05:
                        coef_set(sum & 0x3f);
                        break;
                    case 0x06:
                        break;
                }
            }
        }        
    }
}
