unsigned char rxFIFO[256], txFIFO[256], raw_data[6];
unsigned char rx_top, rx_end, tx_top, tx_end, phase;
float mean_sum1, mean_sum2, ad_data1[101], ad_data2[101];
int timer_value[6], max_count, fir_lpf, gain, ad_pointer1, ad_pointer2;
const int order = 200;
float xn1[order+1], xn2[order+1];
float a1, a2, b1, c0, y1[3], y2[3], old_1, old_2;
int notch_1, notch_2, emergence, em_count1, em_count2;
const float _60Hz_a1 = 1.936768, _60Hz_a2 = -0.939101, _60Hz_b1 = -1.998579, _60Hz_c0 = 1.642174;
const float _50Hz_a1 = 1.937188, _50Hz_a2 = -0.939101, _50Hz_b1 = -1.999013, _50Hz_c0 = 1.938304;

RawSerial xbee(PA_2, PA_3);
Ticker timer_setup;
AnalogIn analog_value0(A0);
AnalogIn analog_value1(A1);
AnalogIn analog_value2(A2);
AnalogIn analog_value3(A3);
DigitalOut myled(LED1);

void sum_clear(){
    int i;
    for (i=0; i<101; i++) ad_data1[i] = ad_data2[i] = 0;
    ad_pointer1 = ad_pointer2 = mean_sum1 = mean_sum2 = 0;
}

void coef_set(int herz){
    if(herz < 55){
        a1 = _50Hz_a1;
        a2 = _50Hz_a2;
        b1 = _50Hz_b1;
        c0 = _50Hz_c0;
    }
    else{
        a1 = _60Hz_a1;
        a2 = _60Hz_a2;
        b1 = _60Hz_b1;
        c0 = _60Hz_c0;
    }
    for (int i=0; i<3; i++) y1[i] = y2[i] = 0;
}
void common_setup(){
    int i;
    rx_top = rx_end = tx_top = tx_end = phase = 0;
    em_count1 = em_count2 = 0;
    max_count = 100;
    fir_lpf = emergence = old_1 = old_2 = 0;
    gain = 5;
    for (i=0; i<3; i++) timer_value[i] = 0;
    timer_value[3] = 10;
    timer_value[4] = 1500;
    for (i=0; i<=order; i++) xn1[i] = xn2[i] = 0.0;
    sum_clear();
    notch_1 = notch_2 = 1;
    coef_set(60);
}

void timer_interrupt(){
    int i;
    for (i=0; i<6; i++) timer_value[i]++;
}

void tx_fifo_check(){
    if(xbee.writeable() == 1){
        if(tx_top != tx_end){
            xbee.putc(txFIFO[tx_end]);
            ++tx_end &= 255;
        }
    }
}

int rx_fifo_check(){
    unsigned char data;
    if(rx_top != rx_end){
        data = rxFIFO[rx_end];
        ++rx_end &= 255;
        if (data < 33){
            phase = 0;
            return(1);
        }
        raw_data[phase] = data;
        if(++phase > 5) phase = 0;
        return(0);
    }
    return(0);
}

void rx_fifoset(void){
    rxFIFO[rx_top] = xbee.getc();
    ++rx_top &= 255;
}

void tx_fifoset(unsigned char data){
    txFIFO[tx_top] = data;
    ++tx_top &= 255;
}

unsigned char hex_conv(unsigned char data){
    data &= 15;
    if(data < 10) return(data+48);
    else return(data+55);
}

unsigned char conv_hex(unsigned char data){
    if((data > 47) && (data < 58)) return(data-48);
    else if((data > 64) && (data < 71)) return(data-55);
    return(0);
}

void tx_message(int data){
    int i;
    for (i=0; i<6; i++) tx_fifoset(hex_conv((data>>(4*(5-i))) & 15));
    tx_fifoset(13);
}

float move_mean_calc1(float data){
    mean_sum1 = mean_sum1 - ad_data1[ad_pointer1] + data;
    ad_data1[ad_pointer1] = data;
    ad_pointer1++;
    if(ad_pointer1 == max_count) ad_pointer1 = 0;
    return(mean_sum1 / (float)max_count);
}

float move_mean_calc2(float data){
    mean_sum2 = mean_sum2 - ad_data2[ad_pointer2] + data;
    ad_data2[ad_pointer2] = data;
    ad_pointer2++;
    if(ad_pointer2 == max_count) ad_pointer2 = 0;
    return(mean_sum2 / (float)max_count);
}
