/*
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
int main(){
    int fs = 10000;
    double  B0, a1, a2, b1, c0, F0, T;
    F0 = 60;    // or 50
    B0 = 100.;
    T  = 1./fs;
    a1 = 2. * exp(-M_PI * B0 * T) * cos(2. * M_PI * F0 * T);
    a2 = -exp(-2. * M_PI * B0 * T);
    b1 = -2. * cos(2. * M_PI * F0 * T);
    c0 = (1-a1-a2)/(2+b1);
    printf("a1 = %f\n", a1);
    printf("a2 = %f\n", a2);
    printf("b1 = %f\n", b1);
    printf("c0 = %f\n", c0);
    return 0;
}
60Hz
    a1 = 1.936768
    a2 = -0.939101
    b1 = -1.998579
    c0 = 1.642174
50Hz
    a1 = 1.937188
    a2 = -0.939101
    b1 = -1.999013
    c0 = 1.938304
*/

float notch_filter1(float data){
    y1[0] = data + a1*y1[1] + a2*y1[2];
    float reault = y1[0] + b1*y1[1] + y1[2];
    y1[2] = y1[1];
    y1[1] = y1[0];
    return(reault);
}

float notch_filter2(float data){
    y2[0] = data + a1*y2[1] + a2*y2[2];
    float reault = y2[0] + b1*y2[1] + y2[2];
    y2[2] = y2[1];
    y2[1] = y2[0];
    return(reault);
}
