#include "mbed.h"
#include "sub.hpp"
#include "FIR_LPF.hpp"
#include "notch.hpp"

int main(){
    common_setup();
    xbee.baud(38400);
    xbee.attach(&rx_fifoset, xbee.RxIrq);
    timer_setup.attach_us(&timer_interrupt, 5); // 5usec
    while(1){
        tx_fifo_check();
        if(timer_value[1] > 19){ // 0.1msec sampling
            timer_value[1] = 0;
            float data1 = (float)gain * (analog_value2.read() - 0.5f);  // A/D in (3)
            if(emergence!=0 && data1<0.05 && data1>0.95){
                data1 = old_1;
                if(++em_count1 > 10){
                    em_count1 = 0;
                    tx_message(0xff0000);   // Emergency 1
                }
            }
            if(data1 < 0) data1 = -data1; // always detection ON
            if(fir_lpf != 0) data1 = FIR_calc1(data1);      // FIR calc (1) call
            if(notch_1 != 0) data1 = notch_filter1(data1);
            old_1 = data1;
            if(timer_value[2] > 2999){  // 15msec
                timer_value[2] = 0;
                if(max_count != 0) data1 = move_mean_calc1(data1);
                tx_message((uint16_t)((data1 + 1.0f) * 2047)<<4);
            }
        }
        if(timer_value[3] > 19){ // 0.1msec sampling
            timer_value[3] = 0;
            float data2 = (float)gain * (analog_value3.read() - 0.5f);  // A/D in (4)
            if(emergence!=0 && data2<0.05 && data2>0.95){
                data2 = old_2;
                if(++em_count2 > 10){
                    em_count2 = 0;
                    tx_message(0xff0001);   // Emergency 2
                }
            }
            if(data2 < 0) data2 = -data2; // always detection ON
            if(fir_lpf != 0) data2 = FIR_calc2(data2);      // FIR calc (1) call
            if(notch_2 != 0) data2 = notch_filter2(data2);
            old_2 = data2;
            if(timer_value[4] > 2999){  // 15msec
                timer_value[4] = 0;
                if(max_count != 0) data2 = move_mean_calc2(data2);
                tx_message(0x400000 + ((uint16_t)((data2 + 1.0f) * 2047)<<4));
            }
        }
        if(timer_value[0] > 199999){ // 1000msec
            timer_value[0] = 0;
            myled = !myled;
        }
        if(rx_fifo_check() == 1){
            int sum = 0;
            for (int i=0; i<6; i++) sum += conv_hex(raw_data[i])<<(4*(5-i));
            tx_message(sum); // Echo Back 
            if(sum>>16 == 0x80){
                switch((sum & 0xff00)>>8){
                    case 0x00:
                        fir_lpf = sum & 0x01;
                        break;
                    case 0x01:
                        gain = sum & 0x0f;
                        break;
                    case 0x02:
                        max_count = sum & 0x7f;
                        if (max_count>100) max_count = 100;
                        sum_clear();
                        break;
                    case 0x03:
                        notch_1 = sum & 0x01;
                        break;
                    case 0x04:
                        notch_2 = sum & 0x01;
                        break;
                    case 0x05:
                        coef_set(sum & 0x3f);
                        break;
                    case 0x06:
                        emergence = sum & 0x01;
                        break;
                }
            }
        }        
    }
}
