const int order = 200;
float xn[order+1];

// from CQpub0 Mikami / FIR_LPF_Direct
//  http://developer.mbed.org/users/CQpub0Mikami/code/FIR_LPF_Direct
//
//                                   Band1       Band2
// Lower band edge frequency (kHz) 0.000000    0.600000
// Upper band edge frequency (kHz) 0.500000    5.000000
// Gain                            1.000000    0.000000
// Weight                          1.000000    1.000000
// Deviation                       0.009734    0.009734
// Deviation [dB]                  0.084139  -40.234188

const float fc[order+1] = {   
    -3.566292E-03f,  2.335185E-03f,  1.917338E-03f,  1.681921E-03f,  1.522689E-03f,
     1.364066E-03f,  1.157961E-03f,  8.803014E-04f,  5.296940E-04f,  1.236180E-04f,
    -3.047488E-04f, -7.123405E-04f, -1.051992E-03f, -1.279654E-03f, -1.360180E-03f,
    -1.273725E-03f, -1.018960E-03f, -6.155554E-04f, -1.029986E-04f,  4.621914E-04f,
     1.013316E-03f,  1.480161E-03f,  1.798055E-03f,  1.916527E-03f,  1.805744E-03f,
     1.463100E-03f,  9.143371E-04f,  2.130115E-04f, -5.640853E-04f, -1.326518E-03f,
    -1.978121E-03f, -2.430574E-03f, -2.613837E-03f, -2.486610E-03f, -2.043447E-03f,
    -1.317959E-03f, -3.802110E-04f,  6.680631E-04f,  1.704594E-03f,  2.600376E-03f,
     3.235972E-03f,  3.515095E-03f,  3.379365E-03f,  2.817894E-03f,  1.872141E-03f,
     6.322899E-04f, -7.684087E-04f, -2.167773E-03f, -3.393601E-03f, -4.284042E-03f,
    -4.705797E-03f, -4.577073E-03f, -3.875274E-03f, -2.648668E-03f, -1.012065E-03f,
     8.616354E-04f,  2.758435E-03f,  4.447251E-03f,  5.706155E-03f,  6.350451E-03f,
     6.257734E-03f,  5.386359E-03f,  3.786968E-03f,  1.602121E-03f, -9.435526E-04f,
    -3.565645E-03f, -5.948320E-03f, -7.781761E-03f, -8.797770E-03f, -8.807067E-03f,
    -7.725336E-03f, -5.594939E-03f, -2.585050E-03f,  1.010693E-03f,  4.809328E-03f,
     8.361672E-03f,  1.121444E-02f,  1.295107E-02f,  1.324389E-02f,  1.191081E-02f,
     8.934171E-03f,  4.488148E-03f, -1.062401E-03f, -7.182842E-03f, -1.321242E-02f,
    -1.841506E-02f, -2.204769E-02f, -2.343209E-02f, -2.202840E-02f, -1.749386E-02f,
    -9.730157E-03f,  1.092382E-03f,  1.453105E-02f,  2.989524E-02f,  4.629194E-02f,
     6.269474E-02f,  7.802411E-02f,  9.123583E-02f,  1.014078E-01f,  1.078185E-01f,
     1.100078E-01f,  1.078185E-01f,  1.014078E-01f,  9.123583E-02f,  7.802411E-02f,
     6.269474E-02f,  4.629194E-02f,  2.989524E-02f,  1.453105E-02f,  1.092382E-03f,
    -9.730157E-03f, -1.749386E-02f, -2.202840E-02f, -2.343209E-02f, -2.204769E-02f,
    -1.841506E-02f, -1.321242E-02f, -7.182842E-03f, -1.062401E-03f,  4.488148E-03f,
     8.934171E-03f,  1.191081E-02f,  1.324389E-02f,  1.295107E-02f,  1.121444E-02f,
     8.361672E-03f,  4.809328E-03f,  1.010693E-03f, -2.585050E-03f, -5.594939E-03f,
    -7.725336E-03f, -8.807067E-03f, -8.797770E-03f, -7.781761E-03f, -5.948320E-03f,
    -3.565645E-03f, -9.435526E-04f,  1.602121E-03f,  3.786968E-03f,  5.386359E-03f,
     6.257734E-03f,  6.350451E-03f,  5.706155E-03f,  4.447251E-03f,  2.758435E-03f,
     8.616354E-04f, -1.012065E-03f, -2.648668E-03f, -3.875274E-03f, -4.577073E-03f,
    -4.705797E-03f, -4.284042E-03f, -3.393601E-03f, -2.167773E-03f, -7.684087E-04f,
     6.322899E-04f,  1.872141E-03f,  2.817894E-03f,  3.379365E-03f,  3.515095E-03f,
     3.235972E-03f,  2.600376E-03f,  1.704594E-03f,  6.680631E-04f, -3.802110E-04f,
    -1.317959E-03f, -2.043447E-03f, -2.486610E-03f, -2.613837E-03f, -2.430574E-03f,
    -1.978121E-03f, -1.326518E-03f, -5.640853E-04f,  2.130115E-04f,  9.143371E-04f,
     1.463100E-03f,  1.805744E-03f,  1.916527E-03f,  1.798055E-03f,  1.480161E-03f,
     1.013316E-03f,  4.621914E-04f, -1.029986E-04f, -6.155554E-04f, -1.018960E-03f,
    -1.273725E-03f, -1.360180E-03f, -1.279654E-03f, -1.051992E-03f, -7.123405E-04f,
    -3.047488E-04f,  1.236180E-04f,  5.296940E-04f,  8.803014E-04f,  1.157961E-03f,
     1.364066E-03f,  1.522689E-03f,  1.681921E-03f,  1.917338E-03f,  2.335185E-03f,
    -3.566292E-03f
};

float FIR_calc(float data){
    int i;
    float acc = 0;
    xn[0] = data;
    for (i=0; i<=order; i++) acc = acc + fc[i]*xn[i];
    for (i=order; i>0; i--) xn[i] = xn[i-1];
    return(acc);
}