#include "mbed.h"

Serial xbee(PA_2, PA_3);

int hex_conv(int data) {
    data = data%16;
    switch(data){
        case 0: return(48);
        case 1: return(49);
        case 2: return(50);
        case 3: return(51);
        case 4: return(52);
        case 5: return(53);
        case 6: return(54);
        case 7: return(55);
        case 8: return(56);
        case 9: return(57);
        case 10: return(65);
        case 11: return(66);
        case 12: return(67);
        case 13: return(68);
        case 14: return(69);
        case 15: return(70);
    }
    return(0);
}

int hex_send(int data) {
    data = data & 255;
    xbee.putc(hex_conv(data / 16));
    xbee.putc(hex_conv(data % 16));
    return(0);
}

int main() {
    int i = 0;
    int j = 0;
    xbee.baud(38400);
    while(1) { 
        j++;
        if(j > 1000000){
            j = 0;
            i = (i+1)%16777216;
            hex_send(i>>16 & 255);
            hex_send(i>>8 & 255);
            hex_send(i & 255);
            xbee.putc(13);
        }
    }
}