#pragma once

#include "mbed.h"
#include <vector>
#include <utility>

class InterruptHandler {
    const PinName INTERRUPT_STATUS_PIN = NC;

public:

    InterruptHandler(PinName irq_pin, PinName status_pin = D2)
        : irq(irq_pin), status(INTERRUPT_STATUS_PIN) {
        if (status.is_connected())
            status = 1;
    }

    void clear() {
    }

    InterruptIn& getIRQ() {
        return irq;
    }

    void enableCallback(int index = 0) {
        enable = true;
    }

    void disableCallback(int index = 0) {
        enable = false;
    }

    void trigger() {
        if (status.is_connected()) {
            if (status)
                status = 0;
            else
                status = 1;
        }
        if (enable) {
            fptr.call();
        }
    }

    int addCallback(void (*isr)(void), bool enable = true) {
        fptr.attach(isr);
        this->enable = enable;
        return 0;
    }

    template <typename T>
    int addCallback(T* tptr, void (T::*isr)(void), bool enable = true) {
        fptr.attach(tptr, isr);
        this->enable = enable;
        return 0;
    }

private:
    InterruptIn irq;
    FunctionPointer fptr;
    bool enable;
    DigitalOut status;
};
