#include "nrf905.h"
#include "mbed.h"


/** define a ultity */


unsigned char config_info_buf[10]={
        0x76,                   //CH_NO,868.4MHZ
        0x0E,                   //output power 10db, resend disable, Current Normal operation
        0x44,                   //4-byte address
        0x20,0x20,              //receive or send data length 32 bytes
        0xCC,0xCC,0xCC,0xCC,    //receiving address
        0x58,                   //CRC enable,8bit CRC,external clock disable,16MHZ Oscillator
};

unsigned int freq_tab[10] = {
    0x13e,
    0x076,
    0x076,
    0x076,
    0x177,
    0x02b,
    0x17f,
    0x17f,
    0x17f,
    0x100,
};

//-------------------initial nRF905---------------------------------------------
 NRF905::NRF905(PinName mosi, PinName miso ,PinName sck, PinName csn, PinName ce,PinName pwr , PinName txe ,PinName am ,PinName dr)
            :spi_(mosi,miso,sck),csn_(csn),ce_(ce),pwr_(pwr),txe_(txe),am_(am),dr_(dr)
{
}        
void NRF905::init(void)
{
            
    csn_=1; // Spi disable
    pwr_=1;// nRF905 power on
    ce_=0;// Set nRF905 in standby mode
    txe_=0;// set radio in Rx mode
    spi_.format(8,0);
      /** wait for nrf905 STANDBY */
    wait(3);
}    
 
//---------------wite to configuration register-----------------
void NRF905::write_config(unsigned char *conf_buf)
{
    csn_=0;                      // Spi enable for write a spi command
    /** send write configuration command */
    spi_.write(WC);
    for (int i=0;i<10;i++)  // Write configration words
    {
       spi_.write(conf_buf[i]);
    }
    csn_=1;                 // Disable Spi
} 

void NRF905::write_config(nrf905_freq_type freq_band)
{
    if(freq_band < 10){
        config_info_buf[0] = freq_tab[freq_band];
        if(freq_tab[freq_band]&0x100){
            config_info_buf[1] |= 0x01;
        }else{
            config_info_buf[1] &= ~0x01;
        }
    }
    // Spi enable for write a spi command
    csn_=0;
    /** send write configuration command */
    spi_.write(WC);
    for (int i=0;i<10;i++)  // Write configration words
    {
       spi_.write(config_info_buf[i]);
    }
    csn_=1;                 // Disable Spi
} 

void NRF905::read_config(unsigned char *conf_buf)
{
    csn_=0;                      // Spi enable for write a spi command

    /** send read configuration command */
    spi_.write(RC);
    for (int i=0;i<10;i++)
    {
       conf_buf[i] = spi_.write(0x00);
    }
    csn_=1;                 // Disable Spi
} 

void  NRF905::RX(unsigned char *TxRxBuffer)
{
    set_rx();           // Set nRF905 in Rx mode
    while (check_ready()==0);
    wait(1);
    RxPacket(TxRxBuffer);
    wait(1);
}

void NRF905::RX(unsigned char *TxRxBuf, unsigned char *RxAddress)
{
    if(config_info_buf[5] != RxAddress[0] ||\
       config_info_buf[6] != RxAddress[1] ||\
       config_info_buf[7] != RxAddress[2] ||\
       config_info_buf[8] != RxAddress[3])
    {

        config_info_buf[5] = RxAddress[0];
        config_info_buf[6] = RxAddress[1];
        config_info_buf[7] = RxAddress[2];
        config_info_buf[8] = RxAddress[3];

        write_config(config_info_buf);
    }

    set_rx();           // Set nRF905 in Rx mode
    while (check_ready()==0);
    wait(1);
    RxPacket(TxRxBuf);
    wait(1);
}

void NRF905::TX(unsigned char *TxRxBuf, unsigned char *TxAddress)
{
    set_tx();
    wait(1);
    // Send data by nRF905
    TxPacket(TxAddress, TxRxBuf);
}

void NRF905::TX(unsigned char *TxRxBuf)
{
    set_tx();
    wait(1);
    // Send data by nRF905
    TxPacket(config_info_buf+5, TxRxBuf);

}

void NRF905::TxPacket(unsigned char *TxAddress, unsigned char *TxRxBuf)
{
    int i;
    csn_=0;
    // Write payload command
    spi_.write(WTP);
    for (i=0;i<32;i++){
        // Write 32 bytes Tx data
        spi_.write(TxRxBuf[i]);
    }
    csn_=1;
    wait(1);

    // Spi enable for write a spi command
    csn_=0;
    // Write address command
    spi_.write(WTA);
    // Write 4 bytes address
    for (i=0;i<4;i++){
        spi_.write(TxAddress[i]);
    }
    // Spi disable
    csn_=1;

    // Set TRX_CE high,start Tx data transmission, CE pulse
    txe_=1;
    wait(1);
    txe_=0;
}

void NRF905::set_tx(void)
{
    ce_=0;
    txe_=1;
    // delay for mode change(>=650us)
    wait(1);
}


void NRF905::set_rx(void)
{
    txe_=0;
    ce_=1;
    // delay for mode change(>=650us)
    wait_ms(800);
};

unsigned char NRF905::check_ready(void)
{
    if(dr_==1) {
        return 1;
    }
    else{
        return 0;
    }
}

void NRF905::RxPacket(unsigned char *TxRxBuffer)
{
    int i;
    ce_=0;
    csn_=0;
    wait(1);
    spi_.write(RRP);
    wait(1);
    for (i = 0 ;i < 32 ;i++){
        TxRxBuffer[i]=spi_.write(NULL);;
        wait(1);
    }
    csn_=1;
    wait(1);
    ce_=1;
    wait(1);
}

        