// reference : http://mbed.org/users/pangsk/programs/ecu_reader/
// Only read CAN-bus data, (not send any data)
// v1.0

/*

mbed Can-Bus demo

This program is to demonstrate the CAN-bus capability of the mbed module.

http://www.skpang.co.uk/catalog/product_info.php?products_id=741

v1.0 July 2010

********************************************************************************

WARNING: Use at your own risk, sadly this software comes with no guarantees.
This software is provided 'free' and in good faith, but the author does not
accept liability for any damage arising from its use.

********************************************************************************


*/

#include "mbed.h"
#include "ecu_reader.h"
#include "globals.h"
#include "TextLCD.h"
#include "SDFileSystem.h"

//GPS gps(p28, p27);
TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d0, d1, d2, d3, for starboard orange
SDFileSystem sd(p5, p6, p7, p8, "sd"); //for starboard orange

/*DigitalIn click(p21);   // Joystick inputs
DigitalIn right(p22);
DigitalIn down(p23);
DigitalIn left(p24);
DigitalIn up(p25);*/

ecu_reader obdii(CANSPEED_500);     //Create object and set CAN speed
//void gps_demo(void);
void sd_demo(void);
//Timer CANTimer;
Timer CANTimer2;

int main() {
    
//    char buffer[20];
 
    lcd.locate(0,0);                // Set LCD cursor position
    lcd.printf("CAN-Bus demo");
    
    lcd.locate(0,1);
    lcd.printf("www.skpang.co.uk");
    pc.baud(460800);
    pc.printf("\n\rCAN-bus demo...");
    
    wait(3);
    lcd.cls();
    

/*    while(1)    // Wait until option is selected by the joystick
    {
   
        if(down == 0) gps_demo();
        if(left == 0) sd_demo(); 
        if(up == 0) break;
        
    }*/

    while(1) {  // Main CAN loop
        led2 = 1;
        wait(0.1);
        led2 = 0;
        wait(0.1);
        
        CANTimer2.reset();
        CANTimer2.start();
        pc.printf("CANTimer.start\n");
        
        while (CANTimer2.read_ms() < TIMEOUT) {
//            pc.printf("CANTimer.read_ms(): %dms ", CANTimer2.read_ms());
            
            // http://mbed.org/cookbook/OBDII-Can-Bus
            
            if (can2.read(can_MsgRx)) {
                pc.printf("Message read\n\r");
                
                 //print message id
                pc.printf("can_MsgRx.id: %x\n\r", can_MsgRx.id);

                //print length of message
                pc.printf("Hex: can_MsgRx.len: %x\n\r", can_MsgRx.len);

                //print data[2]
                //pc.printf("can_MsgRx.data[2]: %x\n\r", can_MsgRx.data[2]);

                for (int i = 0; i < (int)can_MsgRx.len; i++) {
                    pc.printf("can_MsgRx.data[%d]: %x\n\r", i, can_MsgRx.data[i]);
                }
            }
        }
    }




        
        
/*        if(obdii.request(ENGINE_RPM,buffer) == 1)   // Get engine rpm and display on LCD
        {
            lcd.locate(0,0);
            lcd.printf(buffer);
        }   
         
        if(obdii.request(ENGINE_COOLANT_TEMP,buffer) == 1)
        {
            lcd.locate(9,0);
            lcd.printf(buffer);
        }
        
        if(obdii.request(VEHICLE_SPEED,buffer) == 1)
        {
            lcd.locate(0,1);
            lcd.printf(buffer);
        }
     
        if(obdii.request(THROTTLE,buffer) ==1 )
        {
            lcd.locate(9,1);
            lcd.printf(buffer);          
        }
*/
       
}

/*void gps_demo(void)
{
    lcd.cls();
    lcd.printf("GPS demo");
    lcd.locate(0,1);
    lcd.printf("Waiting for lock");
 
    wait(3);    
    lcd.cls();
   
    while(1)
    {
      if(gps.sample()) {
         lcd.cls();
        lcd.printf("Long:%f", gps.longitude);
           lcd.locate(0,1);
        lcd.printf("Lat:%f", gps.latitude);
            pc.printf("I'm at %f, %f\n", gps.longitude, gps.latitude);
        } else {
            pc.printf("Oh Dear! No lock :(\n");
            lcd.cls();
            lcd.printf("Waiting for lock");
   
        }
    }
 
}*/

/*
void sd_demo(void)
{
    lcd.cls();
    lcd.printf("SD demo");
    wait(2);      
    lcd.cls();
    
    FILE *fp = fopen("/sd/sdtest2.txt", "w");
    if(fp == NULL) {
        lcd.cls();
        lcd.printf("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World! testing 1234");
    fclose(fp); 
    lcd.locate(0,1);
    lcd.printf("Writtern to SD card");
        
    while(1)
    {
        led2 = 1;
        wait(0.1);
        led2 = 0;
        wait(0.1);
   
    }
 
}
*/