#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h" 

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define ELEC0 9                                     //Electrodos TSI
#define ELEC1 10
#define NO_ACTIVO 0
#define ACTIVO 1
#define TIEMPO_ACTIVO1 100
#define TIEMPO_ACTIVO2 1700
#define PERIODO_INACTIVO 500
#define ANTIRREBOTE 40
#define EJES 250
#define INICIO '@'
#define FIN '#'
#define ENVIAR_EJE_X '1'
#define ENVIAR_EJE_Y '2'
#define ENVIAR_EJE_Z '3'
#define ENVIAR_ENTRADA_ANALOGICA '4'
#define ENVIAR_ENTRADA_DIGITAL '5'

void Timer_Interrupt();
void UART_Interrupt();
char Recepcion(char);
void Dato_Enviar(double);

PinName const SDA = PTE25;                          //Config I2C Acelerometro
PinName const SCL = PTE24;

int Cont_Blink = 0, Rebote = 0, Cont_Ejes = 0;
bool Activo = 0;
char Caracter = 0;
bool Nuevo_Char = 0;
char Accion, Dato_a_Enviar[3];

Ticker ticker; //Inicializo un Timer

DigitalIn InputRef(PTB9);
DigitalOut LED_EXTERNO(PTB1);
DigitalOut ROJO(LED_RED);
DigitalOut AZUL(LED_BLUE);
DigitalOut VERDE(LED_GREEN);

AnalogIn Analog_Voltage(A0);

RawSerial UART(USBTX, USBRX); 

int main() {
    ticker.attach(&Timer_Interrupt, 0.001); //Se llamara a la funcion de timer cada 1mS
    UART.attach(&UART_Interrupt); //Cada vez que se recibe algo se llama a la interrupcion de UART
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40); //Configuro cosita tactil
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS); //Configuro Acelerometro
    
    double Tactil = 0;
    bool Toque = 1, Rx_OK = 0, Leer_Ejes = 0;
    double EjeX = 0, EjeY = 0, EjeZ = 0;
    char Signo = 0, Verif = 0, Etapa_Activo = 1;
    ROJO = 1; VERDE = 1; AZUL = 1;
    
    while(1) {
        Tactil = tsi.readPercentage();
        
        if(1 >= 3.3*Analog_Voltage){
            ROJO = 0; VERDE = 1; AZUL = 1;
        }else if(2 < 3.3 * Analog_Voltage){
            ROJO = 1; VERDE = 1; AZUL = 0;
        }else{
            ROJO = 1; VERDE = 0; AZUL = 1;   
        }
        
        if(Cont_Ejes >= EJES){ 
            Leer_Ejes = 1;
            Cont_Ejes = 0;
        }
        if(Leer_Ejes){
            EjeX = acc.getAccX();
            EjeY = acc.getAccY();
            EjeZ = acc.getAccZ();
            Leer_Ejes = 0;
        }
        
        if(Tactil != NO_TOUCH && !Rebote && !Toque){
            Rebote = 1; Toque = 1;
        }
                
        if(Tactil == NO_TOUCH) Toque = 0;
        
        if(Rebote >= ANTIRREBOTE){
            if(!Activo) Activo = ACTIVO;
            else Activo = NO_ACTIVO;
            Rebote = 0;
        }
        
        if(Activo){
            switch(Etapa_Activo){
                case 1:
                    LED_EXTERNO = 1;
                    if(Cont_Blink >= TIEMPO_ACTIVO1){
                        Etapa_Activo = 2;
                        Cont_Blink = 0;
                    }
                break;
                case 2:
                    LED_EXTERNO = 0;
                    if(Cont_Blink >= TIEMPO_ACTIVO1){
                        Etapa_Activo = 3;
                        Cont_Blink = 0;
                    }
                break;
                case 3:
                    LED_EXTERNO = 1;
                    if(Cont_Blink >= TIEMPO_ACTIVO1){
                        Etapa_Activo = 4;
                        Cont_Blink = 0;
                    }
                break;
                case 4:
                    LED_EXTERNO = 0;
                    if(Cont_Blink >= TIEMPO_ACTIVO2){ 
                        Etapa_Activo = 1;
                        Cont_Blink = 0;
                    }
                break;
            }   
        }else{
            if(Cont_Blink < PERIODO_INACTIVO/2) LED_EXTERNO = 1;
            else LED_EXTERNO = 0;
        
            if(Cont_Blink >= PERIODO_INACTIVO) Cont_Blink = 0;
        }
        
        if(Nuevo_Char && Activo){
            Rx_OK = Recepcion(Caracter);
            Nuevo_Char = 0;
        }
        
        if(Rx_OK){
            
            if(Accion == ENVIAR_EJE_X){
                if(EjeX < 0){
                     EjeX = EjeX * -1;
                     Signo = '-';
                }else Signo = '+';
                Dato_Enviar(EjeX);
                Verif = INICIO ^ ENVIAR_EJE_X ^ Signo ^ Dato_a_Enviar[2] ^ Dato_a_Enviar[1] ^ Dato_a_Enviar[0];
                printf("@1%c%c%c%c%x%x%c\r\n",Signo, Dato_a_Enviar[2], Dato_a_Enviar[1], Dato_a_Enviar[0],(Verif & 0xF0) >> 4, Verif & 0x0F, FIN);
            }
            if(Accion == ENVIAR_EJE_Y){
                if(EjeY < 0){
                     EjeY = EjeY * -1;
                     Signo = '-';
                }else Signo = '+';
                Dato_Enviar(EjeY);
                Verif = INICIO ^ ENVIAR_EJE_Y ^ Signo ^ Dato_a_Enviar[2] ^ Dato_a_Enviar[1] ^ Dato_a_Enviar[0];
                printf("@2%c%c%c%c%x%x%c\r\n",Signo, Dato_a_Enviar[2], Dato_a_Enviar[1], Dato_a_Enviar[0],(Verif & 0xF0) >> 4, Verif & 0x0F, FIN);
            }
            if(Accion == ENVIAR_EJE_Z){
                if(EjeZ < 0){
                     EjeZ = EjeZ * -1;
                     Signo = '-';
                }else Signo = '+';
                Dato_Enviar(EjeZ);
                Verif = INICIO ^ ENVIAR_EJE_Z ^ Signo ^ Dato_a_Enviar[2] ^ Dato_a_Enviar[1] ^ Dato_a_Enviar[0];
                printf("@3%c%c%c%c%x%x%c\r\n",Signo, Dato_a_Enviar[2], Dato_a_Enviar[1], Dato_a_Enviar[0],(Verif & 0xF0) >> 4, Verif & 0x0F, FIN); 
            }
            if(Accion == ENVIAR_ENTRADA_ANALOGICA){
                Dato_Enviar(Analog_Voltage*3.3);
                Verif = INICIO ^ ENVIAR_ENTRADA_ANALOGICA ^ Dato_a_Enviar[2] ^ Dato_a_Enviar[1] ^ Dato_a_Enviar[0];
                printf("@4%c%c%c%x%x%c\r\n", Dato_a_Enviar[2], Dato_a_Enviar[1], Dato_a_Enviar[0],(Verif & 0xF0) >> 4, Verif & 0x0F, FIN);
            }
            if(Accion == ENVIAR_ENTRADA_DIGITAL){
                Verif = INICIO ^ ENVIAR_ENTRADA_DIGITAL ^ (InputRef + 48);
                printf("@5%c%x%x%c\r\n", InputRef + 48,(Verif & 0xF0) >> 4, Verif & 0x0F, FIN);
            }
            
            Rx_OK = 0;
        }
    }
}

void Timer_Interrupt(){
    Cont_Blink++;
    Cont_Ejes++;
    if(Rebote > 0) Rebote++;    
}

void UART_Interrupt(){
    Caracter = UART.getc();
    Nuevo_Char = 1;
}

char Recepcion(char Dato){
       char Ok = 0;
       static char Estado = 0;
       switch(Estado){
        case(0):
            if(Dato == INICIO)
               Estado = 1;                
        break;
        case(1):
            Accion = Dato;
            Estado = 2;
        break;
        case(2):
            if(Dato != FIN){
                Accion = 0;
            }else
                Ok = 1;
            Estado = 0;
        break;
    }
    
    return Ok;
}

void Dato_Enviar(double Dato){
        Dato_a_Enviar[2] = (char)Dato;
        Dato_a_Enviar[1] = ((char)(Dato*10))%10;
        Dato_a_Enviar[0] = (char)(Dato*100.0f - Dato_a_Enviar[2]*100 - Dato_a_Enviar[1]*10) + 48;
        Dato_a_Enviar[2] += 48;
        Dato_a_Enviar[1] += 48;
}
