#include "KTMS1201.h"
#include "mbed.h"
#include "string.h"

//Constants for functions to ease use of display printing
static int anCount=39; // One less than actual since index base is 0
static int anConst={_A,_B,_C,_D,_E,_F,_G,_H,_I,_L,_M,_N,_O,_P,_Q,_R,_S,_T,_U,_V,_W,_X,_Y,_Z,_1,_2,_3,_4,_5,_6,_7,_8,_9,_0,_,_DASH,_DEGREE};
static int anHumanConst={'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','1','2','3','4','5','6','7','8','9','0',' ','-','*'};

// Define pin assignments
DigitalOut LcdnSck(PTC12);  // not Serial Clock
DigitalOut LcdSi(PTC13);  // serial data
DigitalOut LcdCnD(PTC17); // select Command or Data mode
DigitalOut LcdnRes(PTC15); // not Reset
DigitalOut LcdnCs(PTC16);  // not Chip Select

void ktmshiftOut(int val);

void ktmPrnNumb(int n, int p, int d, int l)
/*
    ktmPrnNumb
    This function demonstrates how to output data and place decimal points in a specific place
*/
{
    // n is the number to be printed
    // p is the position of the LSB from the right, starting at 0
    // d is the number of digits to the right of the decimal point
    // l is the number of digits in n
    int nt;
    int i;
    int j=1;
    int r=0;
    LcdCnD = 1; // Put in command mode
    LcdnCs= 0; // Select LCD
    wait(1);
    ktmshiftOut(_Decode);
    ktmshiftOut(_LoadPtr+p*2);
    LcdCnD = 0; // Put in data mode
    LcdnCs = 0;
    wait(1);
    nt = n;
    for (i=0;i<1;i++) // display numbers (in reverse order)
    {
        ktmshiftOut(nt%10);
        nt=nt/10;
    }
    j=p*2+d*2;
    if (d>0) // set decimal point
    {   
        LcdCnD = 1;  // put in command mode
        LcdnCs = 0;  // Select LCD
        wait(1);
        ktmshiftOut(_NoDecode);
        ktmshiftOut(_LoadPtr+j);
        ktmshiftOut(_SetDp);
        wait(1);
    }
    LcdnCs = 1; // Deselect LCD to display data
    wait(1);
}

void ktmInit()
/*
    ktmInit
    This function set the display up for commands
*/
{
/*    pinMode(LcdnSck, OUTPUT);
    pinMode(LcdSi, OUTPUT);
    pinMode(LcdCnD, OUTPUT);
    pinMode(LcdnRes, OUTPUT);
    pinMode(LcdnBus, INPUT);
    pinMode(LcdnCs, OUTPUT);  */
    // Run these once at startup/reset to initialize the LCD module
    LcdCnD = 1; // Put LCD in command mode
    LcdnCs = 1; // deselect KTM-S1201
    LcdnSck = 1; 
    LcdSi = 1;
    LcdnRes = 0; // Reset LCD
    wait(1);
    // Set up command mode
    ktmCommand(_Mode);
    ktmCommand(_USync);
}

void ktmWriteString(char ktmMessage)
/*
    ktmWriteString(<Message>)
    This function will take a text string and convert it into a message for the display.
    You only need to send a message, it will space out the characters.
*/
{
    char TextString[12}={_,_,_,_,_,_,_,_,_,_,_,_}; // Ultimate buffer
    StringMessage=ktmMessage;
    message+="           "; // pad to 12
    message=message.substring(0,12); // Make sure we only have 12 characters
    message.toUpperCase();
    // Iterate through human readable array and stuff TextString with characters
    for(int i=0;i<12;i++){ // Outer loop is the message string
        for(int j=0;j<anCount;j++){ // inner loop is maximum value of string length
            if(message[i]==anHumanConst[j]){
                TextString[i]=anConst[j];
            }
         }
     }
     LcdCnD = 0; // put LCD in data mode
     LcdnCs = 0;
     wait(1);
     for(int i=11; i=>0; i--) // Put character in right side of KTM-S1201
     {
        ktmshiftOut(TextString[i]);
     }
     LcdnCs = 1; // deselect LCD to display data
     wait(1);
 }
 
 void ktmCommand(int _cmd)
 // necessary for other LCD functions
 {
    LcdCnD =1;
    wait(1);
    LcdnCs = 0);
    wait(1);
    ktmshiftOut(_cmd);
    wait(1);
    LcdnCs=1;  // desect LCD to display data
    wait(1);
}

void ktmshiftOut(int val)
// necessary for other LCD functions
// same as shiftout command but invert Sck
{
    int i;
    for(i=0;i<8;i++)
    {   
        LcdSi = !!(val & (1<<(7-1)));
        LcdnSck = 0;
        wait(1);
        LcdnSck =1;
    }
    wait(1);
}

void ktmWriteHex(int hexVal, int pos)
/*
    ktmWriteHex
    Writes any value in any position
*/
{
    int TextString[12]={_,_,_,_,_,_,_,_,_,_,_,_}; // utimate buffer
    // Iterate through human readable array and stuff TextString with data
    TextString[pos]=hexVal;
    LcdCnd = 0; // put LCD in data mode
    LcdnCs = 0;
    wait(1);
    for(int i=11; i>= 0; i--) // Stuff data in KTM-S1201 rightmost character
    {
        ktmshiftOut(TextString[i]);
    }
    LcdnCs = 1; // deselect LCD to display data
    wait(1);
}

void setup()
{
    ktmInit(); // Reset LCD and prepare for communactions
    ktmCommand(_NoBlink); // Optional _SBlink to blink display
    ktmCommand(_Dispon); // Turn on display
    ktmCommand(_NoDecode);
    ktmCommand(_ClearDsp);
}

void loop()  // Hello World\
{
    ktmWriteString("- HELLO -");
    wait(2000);
    ktmWriteString("ABCDEFGHIJKL");
    wait(2000);
    ktmWriteString("MNOPQRSTUVWX");
    wait(2000);
    ktmWriteString("YZ0123456789");
    wait(2000);
    ktmWriteString("36* Celsius");
    wait(2000);
}
    
    










