#include "mbed.h"
#include "x_nucleo_iks01a1.h"
#include "mbed.h"
#include "ble/BLE.h"
#include "ble/services/HeartRateService.h"
#include "ble/services/BatteryService.h"
#include "ble/services/DeviceInformationService.h"
//#include "stm32f4xx_conf.h"
//#include "stm32f4xx.h"
#include "led_RGB.h"
#include "main.h"

BLE ble;
DigitalOut led1(LED1);

const static char DEVICE_NAME[] = "HRM1";
static const uint16_t uuid16_list[] = {GattService::UUID_HEART_RATE_SERVICE,
GattService::UUID_DEVICE_INFORMATION_SERVICE};
static volatile bool triggerSensorPolling = false;

uint8_t clock_source;

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    ble.gap().startAdvertising(); // restart advertising
}

void periodicCallback(void)
{
    led1 = !led1;
    triggerSensorPolling = true;
}


static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;



Serial pc(USBTX, USBRX);
/* Simple main function */
int main() {
  uint8_t id;
  int32_t axes[3];
  pc.baud(115200);
  printf("\r\n--- Starting new run ---\r\n");
  
    RCC_DeInit();
    RCC_HSICmd(ENABLE);
    while(RCC_GetFlagStatus(RCC_FLAG_HSIRDY) == RESET);
    RCC_PLLConfig(RCC_PLLSource_HSI, 8, 336, 4, 7);
    RCC_PLLCmd(ENABLE);
    while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY)==RESET);
    RCC_HCLKConfig(RCC_SYSCLK_Div1);
    RCC_PCLK2Config(RCC_HCLK_Div2); //APB2 84MHz/2 = 42MHz
    RCC_PCLK1Config(RCC_HCLK_Div2);
    clock_source = RCC_GetSYSCLKSource();
    if (clock_source !=0)
        RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);
    RCC_AHB1PeriphClockCmd( RCC_AHB1Periph_GPIOA |
                            RCC_AHB1Periph_GPIOB,
                            ENABLE);
    RCC_APB1PeriphClockCmd( RCC_APB1Periph_TIM3 |
                            RCC_APB1Periph_TIM4 |
                            RCC_APB1Periph_TIM2,
                            ENABLE);
    RCC_APB2PeriphClockCmd( RCC_APB2Periph_USART1,
                            ENABLE);
                            
    Blue_Red_Setup();
    Green_Setup();
  
  
  
  magnetometer->ReadID(&id);
  printf("LIS3MDL magnetometer              = 0x%X\r\n", id);
  
    led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1); // blink LED every second
    
    ble.init();
    ble.gap().onDisconnection(disconnectionCallback);
    
    /* Setup primary service. */
    uint8_t hrmCounter = 0; // init HRM to 100bps
    HeartRateService hrService(ble, hrmCounter, HeartRateService::LOCATION_FINGER);
    
    /* Setup auxiliary service. */
    DeviceInformationService deviceInfo(ble, "ARM", "Model1", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
    
    /* Setup advertising. */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_HEART_RATE_SENSOR);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms */
  
    ble.gap().startAdvertising();
  

  uint8_t  note = 0;
  while(1) {
    if (triggerSensorPolling && ble.getGapState().connected) {
        triggerSensorPolling = false;

        magnetometer->Get_M_Axes(axes);
        //printf("%6ld,\t %6ld,\t %6ld\r\n", axes[0], axes[1], axes[2]);
        
        note = 0;
        if (axes[0]>-81-40 && axes[0]<23+40 && axes[1]>-259-40 && axes[1]<-167+40 && axes[2]>827-40 && axes[2]<981+40)
            note = 1;
        else if (axes[0]>163-40 && axes[0]<289+40 && axes[1]>-397-40 && axes[1]<-316+40 && axes[2]>311-40 && axes[2]<357+40)
            note = 2;
        else if (axes[0]>-73-40 && axes[0]<43+40 && axes[1]>-441-40 && axes[1]<-313+40 && axes[2]>335-40 && axes[2]<420+40)
            note = 3;
        else if (axes[0]>-45-40 && axes[0]<25+40 && axes[1]>-612-40 && axes[1]<-561+40 && axes[2]>632-40 && axes[2]<761+40)
            note = 4;
        else if (axes[0]>-64-40 && axes[0]<-6+40 && axes[1]>-7-40 && axes[1]<35+40 && axes[2]>524-40 && axes[2]<677+40)
            note = 5;
        else if (axes[0]>-210-40 && axes[0]<-137+40 && axes[1]>-431-40 && axes[1]<-294+40 && axes[2]>455-40 && axes[2]<615+40)
            note = 6;
        else if (axes[0]>429-40 && axes[0]<471+40 && axes[1]>-145-40 && axes[1]<-91+40 && axes[2]>480-40 && axes[2]<580+40)
            note = 7;
        else if (axes[0]>164-40 && axes[0]<264+40 && axes[1]>-650-40 && axes[1]<-604+40 && axes[2]>560-40 && axes[2]<700+40)
            note = 8;
            
        printf("%d\n", note);
    
        hrService.updateHeartRate(note);
        wait(0.3);
    } else {
        ble.waitForEvent(); // low power wait for event
    }
    switch (note){
            case DO:    TIM_SetCompare4(TIM3, 255); //RED
                        TIM_SetCompare1(TIM4, 0);   //GREEN
                        TIM_SetCompare3(TIM3, 0);   //BLU
                break;
            case RE:    TIM_SetCompare4(TIM3, 255); //RED
                        TIM_SetCompare1(TIM4, 153); //GREEN
                        TIM_SetCompare3(TIM3, 0);   //BLU
                break;
            case MI:    TIM_SetCompare4(TIM3, 255); //RED
                        TIM_SetCompare1(TIM4, 255); //GREEN
                        TIM_SetCompare3(TIM3, 0);   //BLU
                break;
            case FA:    TIM_SetCompare4(TIM3, 0);   //RED
                        TIM_SetCompare1(TIM4, 255); //GREEN
                        TIM_SetCompare3(TIM3, 0);   //BLU
                break;
            case SOL:   TIM_SetCompare4(TIM3, 0);   //RED
                        TIM_SetCompare1(TIM4, 0);   //GREEN
                        TIM_SetCompare3(TIM3, 255);     //BLU
                break;
            case LA:    TIM_SetCompare4(TIM3, 51);  //RED
                        TIM_SetCompare1(TIM4, 0);   //GREEN
                        TIM_SetCompare3(TIM3, 153);     //BLU
                break;
            case SI:    TIM_SetCompare4(TIM3, 255); //RED
                        TIM_SetCompare1(TIM4, 0);   //GREEN
                        TIM_SetCompare3(TIM3, 255);     //BLU
                break;
            case DO1:   TIM_SetCompare4(TIM3, 255); //RED
                        TIM_SetCompare1(TIM4, 255); //GREEN
                        TIM_SetCompare3(TIM3, 255);     //BLU
                break;
            case default:
                        TIM_SetCompare4(TIM3, 0);   //RED
                        TIM_SetCompare1(TIM4, 0);   //GREEN
                        TIM_SetCompare3(TIM3, 0);   //BLU
  }
}
