/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @file button.cpp
 * @author Andre Moehl
 * @date 01/2011
 * @brief Button Class definition
 */
 
/*--- Includes ------------------------*/
#include "button.h"

/*--- Functions -----------------------*/
//Contructor 
Button::Button(PinName pin, const char *name): DigitalIn(pin,name)
{
    _counter = 0;
    _samples = 10;
    set_debounce_us(1000);
}

// sets Sample for debounce
void Button::set_samples(int i)
{
        _samples = i;
}

// set debounce time
void Button::set_debounce_us(int i)
{
    _ticker.attach_us(this, &Button::_callback, i);
}

// return the final state   
int Button::read()
{
    return _shadow;
}

//overwrite fuction from derived "DigitalIn"
Button::operator int()
{
    return read();
}


// counts the oscillations of the button
void Button::_callback(void) 
{ 
    if (DigitalIn::read()) 
    { 
        if (_counter < _samples) _counter++; 
        if (_counter == _samples) _shadow = 1; 
    }
    else { 
        if (_counter > 0) _counter--; 
        if (_counter == 0) _shadow = 0; 
    }
}


