/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @file motor.h
 * @author Andre Moehl
 * @date 01/2011
 * @brief Servo Motor Class definition
 */
 


#ifndef __MOTOR_H
#define __MOTOR_H

/*--- Includes ------------------------*/
#include "mbed.h"

/*--- Class Declaration----------------*/

/**
    Class Motor
*/
class Motor
{
    
    public:
        /** @brief Constructor
        *   @parameter Pin Servo Motor Pin
        *   @parameter periode Periode for Servo Signal
        */
        Motor(PinName Pin, int periode);   
        ~Motor();
        /** @brief Sets the pulse width ergo the servo rotation speed 
        *   @parameter value pulsewidth in microseconds as integer
        */
        void speed(int value);     
                
    private:
        PwmOut _PwmPin;

};

#endif