/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @file drive.h
 * @author Andre Moehl
 * @date 01/2011
 * @brief Driver Class definition
 */

#ifndef __DRIVE_H
#define __DRIVE_H

/*--- Includes ------------------------*/
#include "mbed.h"
#include "motor.h"

//duty cycle for motor PWM in ms
#define DUTYCYCLE 20
// pulse width (us) for Motor stop
#define ZERO 1500

#define LEFT 1
#define RIGHT 2

class Drive
{
    public:
    
        /** 
        *   @brief Constructor
        *   @parameter LeftPin Left Motorp Signal Pin 
        *   @parameter RightPin Right Motorp Signal Pin 
        */
        Drive(PinName LeftPin,PinName RightPin);
        /**
         * @ brief Sets the linear speed 
         * @parameter speed value between -100 and 100 % */
        void move(int left, int right);         
        /**
         * @brief sets the motor zero offset
         * @parameter left left motor offset
         * @parameter right right motor offset
         */
        void setoffset(int left, int right);      
        
    private:
        int curr_speed_L;
        int curr_speed_R;
        int offset_L, offset_R;
        Motor _Left;
        Motor _Right;
};

#endif