/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @file drive.cpp
 * @author Andre Moehl
 * @date 01/2011
 * @brief Driver Class definition
 */

/*--- Includes ------------------------*/
#include "drive.h"

/*--- Functions -----------------------*/
//Contructor 
Drive::Drive(PinName LeftPin,PinName RightPin): _Left(LeftPin, DUTYCYCLE), _Right(RightPin, DUTYCYCLE)
{   
    offset_L = 0;
    offset_R = 0;
}

/**
 * @ brief Sets the linear speed 
 * @parameter speed value between -100 and 100 % */
void Drive::move(int left, int right)
{    
    if (left > 120) left = 120;
    if (left < -120) left = -120;
    if (right > 120) right = 120;
    if (right < -120) right = -120;
    
   _Left.speed(ZERO + offset_L + left*6);
   _Right.speed(ZERO - offset_R - right*6);
}

/**
 * @brief sets the motor zero offset
 * @parameter left left motor offset
 * @parameter right right motor offset
 */
void Drive::setoffset(int left, int right)
{
     offset_L = left;
     offset_R = right;
}
  