/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @file button.h
 * @author Andre Moehl
 * @date 01/2011
 * @brief Button Class definition
 */
 
 
/**
*   Usage: 
*        
*   #include "button.h"
*
*   void main()
*   {
*       Button button(p10);
*       int state=0;
*
*       while(1)
*       {
*           if(button) do_something(); 
*       }
*   }
*/

#ifndef __BUTTON_H
#define __BUTTON_H

/*--- Includes ------------------------*/
#include "mbed.h"

/*--- Class Declaration----------------*/

/**
    Class Button - derived from Class DigitalIn
*/
class Button: public DigitalIn
{   
    public:
        /** @brief Contructor 
        *   @parameter  pin button pin
        *   @parameter name  for Pin
        */
        Button(PinName pin, const char *name = NULL); 
        
        /** @brief returns the Button state as integer */
        int read(void);
        
        /** @brief overwrites the int operator for easy use*/
        operator int();
        
        /** @brief Sets the Debounce Time 
        *   @parameter i debounce time in microseconds */
        void set_debounce_us(int i);
        /** @brief Sets the Oscillations to count until Button is debounced
        *   @parameter i Number of Samples */
        void set_samples(int i);
        
    protected:
        void _callback(void);
        Ticker _ticker;
        int _counter;
        int _samples;
        int _shadow;
};

#endif