#include "mbed.h"
#include "stdio.h"
#include "math.h"
#include "C12832.h"

//To Do:
//Fix crc_passed logic

//Improvements:
//Increase bandwidth by reducing wasted nibbles from CRC

//Changes:
//unsigned chars moved
//removed nibble
//added CRC

//multicast using 4bit address / 4 bit network. network = 4 msb, address = 4 lsb. broadcast = all 0's. multicast = network id & address of 0's.
#define MAX 100 //set the size of the character data storage array
#define BYTE 8
#define PREAMBLE 0x7E //preamble of 01111110
#define POSTAMBLE 0x81 //postamble of 10000001
#define ADDRESS 0x11 //address of 00010010 - network of 1, id of 2.
#define BROADCAST 0x00 //address of 00000000
#define CRC 0x13 //crc of 10011 or x^4+x+1 or crc-5

Timer t; //timer for pausing after data RXed before displaying data
DigitalOut myled(LED1); // red led on board
C12832 lcd(p5, p7, p6, p8, p11); //LCD structure
int msecs, sksecs; //clock time needed for data transfer and skew time
DigitalIn clock_pin(p21); //clock pulse input and data input pins
DigitalInOut serial_in(p22);//Recieve, send for ACK

unsigned char temp, crc_calc; //temp byte storage, storage array, transmitted crc value
char c[1];//Used for troubleshooting to send a char to LCD
char data[MAX];//data array
unsigned char preamble, address, i, j, k, temp_data,FCS; //increment variables
unsigned char data_flag, rflag, done_flag1, done_flag2; //data flags
int crc_passed = 0, temp_crc = 0; //CRC Flag, stores values for crc check.

//funtion prototypes
void check_byte(int value); //stays inside the function until the RXed byte matches the value passed into the function (PREAMBLE)
int check_abyte();//after preamble RXed checks the next byte for address. Returns 1 if address RXed matches ADDRESS, BROADCAST, or multicast; 0 if not.
int read_byte(int size); //reads RXed data and returns it a byte at a time.
int get_crc(int temp_crc);//Get CRC value on data temp_crc
void Ms_Delay(int msec);
void lcdClear(void);
void print(char str[]);
void send_ACK(int ACK);

int main()
{
    clock_pin.mode(PullUp);//Enable PullUp Resistors
    serial_in.mode(PullUp);//Enable PullUp Resistors
    myled=0;//Turn LED On
    //clear lcd screen, print current build message
    lcdClear();
    print("Comm Started");
    Ms_Delay(500);//Wait 500mS
    while(true) {
        //initialize variables
        i = 0;
        done_flag1 = 0;
        done_flag2 = 0;
        crc_passed=0;

        while(!done_flag1) {
            //read input clock pulse and data checking for preamble.
            //preamble while loop
            check_byte(PREAMBLE);
            myled=0;//Turn LED On
            //clear lcd screen, print current build message
            lcdClear();
            print("Pre RXed");

            //preamble RXed check address (next byte), returns to preamble check if not addressed to station
            if(check_abyte())
                done_flag1 = 1;
            else {
                //clear lcd screen, print current build message
                lcdClear();
                print("Wait for pre");
            }
        }

        while(!done_flag2) {
            //store data into character array if crc checks.
            temp_data = read_byte(BYTE); //store successfully transmitted data

            //check for postamble
            if(temp_data == POSTAMBLE) {
                //break out of while loop - data finished sending
                done_flag2 = 1;
                //clear lcd screen, print current build message
                lcdClear();
                print("Post RXed");
            }

            //store data in character array if not postamble - check crc when appropriate
            else {
                //byte1, crc1, byte2, crc2
                data[i]=0;
                data[i] = temp_data;
                temp_crc=temp_data<<4;
                FCS = read_byte(BYTE); //store successfully transmitted data
                temp_crc=temp_crc+(FCS & 0x0F);//grab the last 4 bits from crc value byte
                if(get_crc(temp_crc)==0) {
                    crc_passed=1;
                    lcdClear();
                    print("pass CRC");
                } else {
                    crc_passed=crc_passed & 0;//needs to be fixed
                    lcdClear();
                    print("fail CRC");
                }
            }
            i++; //increment array position
            temp_crc = 0;//zero out crc temp variables
        }
        //pause after displaying postamble RXed and then display data.
        //Ms_Delay(1000);//Display Postamble Message
        if(crc_passed) { //if crc passes display data, send ACK
            //clear debugging messages - and reset lcd to original position before printing data.
            //send ACK
            lcdClear();
            print("RXed: ");
            print(data);
            send_ACK(0x1);
//        for(k=0; k<=i; k++)
//            print("%c", data[k]);
        } else { //if crc fails, send NOACK
            send_ACK(0x0);
        }
        myled=1;
        //Ms_Delay(1000);
    }
}

void check_byte(int value)
{
    data_flag = 1;
    temp = 0;
    rflag=0;
    //while loop
    while(!rflag) {
        //read in data if clock is 1 and data flag is 1
        if(clock_pin && data_flag) {
            //data is left shifted into our temporary variable.
            //each new data bit is moved into the least significant bit after the rest of the bits are shifted to the left
            //data must be sent from the other microcontroller shifted out from the most significant bit to the least significant bit.
            temp = (temp << 1) + serial_in;
            data_flag = 0;
            if(temp == value)
                rflag = 1;
        }
        //when clock returns to low - reset data flag to accept the next bit.
        if(!clock_pin && !data_flag)
            data_flag = 1;
    }
}

int check_abyte()
{
    j = 0;
    temp = 0;
    rflag=0;
    //while loop
    while(j<8) {
        //read in data if clock is 1 and data flag is 1
        if(clock_pin && data_flag) {
            //data is left shifted into our temporary variable.
            //each new data bit is moved into the least significant bit after the rest of the bits are shifted to the left
            //data must be sent from the other microcontroller shifted out from the most significant bit to the least significant bit.
            temp = (temp << 1) + serial_in;
            j++;
            data_flag = 0;
        }
        //when clock returns to low - reset data flag to accept the next bit.
        if(!clock_pin && !data_flag)
            data_flag = 1;
    }

    //clear lcd screen, print current build message
    lcdClear();

    if(temp == ADDRESS) {
        rflag = 1;
        print("Addrss RXed");
    } else if(temp == BROADCAST) {
        rflag = 1;
        print("Brdcst RXed");
    } else if(((temp & 0xF0) == (ADDRESS & 0xF0)) && ((temp & 0x0F) == 0)) {
        rflag = 1;
        print("Multicst1 RXed");
    } else if(((temp & 0xF0) == 0) && ((temp & 0x0F) == (ADDRESS & 0x0F))) {
        rflag = 1;
        print("Multicst2 RXed");
        //can add if Network==0 and address==x send to x in every network
    } else {
        print("Wrng addrss RXed");
    }
    Ms_Delay(1000);
    return rflag;
}

int read_byte(int size)
{
    j = 0;
    temp = 0;

    //read a byte/nibble at a time and return it to main
    while(j<size) {
        //read in data if clock is 1 and data flag is 1
        if(clock_pin && data_flag) {
            //data is left shifted into our temporary variable.
            //each new data bit is moved into the least significant bit afater the rest of the bits are shifted to the left
            //data must be sent from the other microcontroller shifted out from the most significant bit to the least significant bit.
            temp = (temp << 1) + serial_in;
            //increment j (tracks bits RXed) - turn off data_flag until clock changes.
            j++;
            data_flag = 0;
        }
        //when clock returns to low - reset data flag to accept the next bit.
        if(!clock_pin && !data_flag)
            data_flag = 1;
    }
    return temp;
}


int get_crc(int temp_crc)
{
    int j = 11, b = 0, z = 0, Y = 0, C0 = 0, C1 = 0, C2 = 0, C3 = 0;
    while(j > -1) {
        b = (temp_crc >> j) % 2;//bit
        Y = C3 ^ b;
        C3 = C2;
        C2 = C1;
        C1 = Y ^ C0;
        C0 = Y;
        j--;
    }
    z=z+C3<<1;
    z=z+C2<<1;
    z=z+C1<<1;
    z=z+C0;
    return z;
}

void Ms_Delay(int msec)//mS Delay
{
    t.start();
    //wait until the timer has reached the set time.
    while(t.read_ms() < msec) {
    }
    //stop and reset the timer
    t.stop();
    t.reset();
}

void lcdClear() //Clear LCD, for LPC,     lcd.cls();,     lcd.locate(0,3);
{
    lcd.cls();
    lcd.locate(0,3);
}

void print(char str[])// print String to LCD Display, for LPC,     printf(str);
{
    lcd.printf(str);
}

void send_ACK(int ACK)
{
    serial_in = ACK;
    Ms_Delay(1500);///////////////can reduce time when Arduino Postamble delay is reduced
//        if(clock_pin) {
//            //if(!clock_pin && skew_flag && t.read_ms() > sksecs) {//output data before clock high
//            serial_in = (byte / j) % 2;
//            j /= 2; //decrement j to get to next bit location
//        }
    //reset skew flag
}