#ifndef TASKDEF_H
#define TASKDEF_H

/**
 * Task ID definition
 */
enum {
    TID_LED = 0,
    TID_ADC,
    TID_KICK,
    NUM_OF_TASKS
};

/**
 * Task Name definition
 */
#define TNAME_LED   "LedTask"
#define TNAME_ADC   "AdcTask"
#define TNAME_KICK  "kickTask"

/**
 * Message ID definition
 */
#define MSG(t,m)                (t<<16 | m)

#define TMSG_LED_TURNON         MSG(TID_LED, 0x01)
#define TMSG_LED_TURNOFF        MSG(TID_LED, 0x02)
#define TMSG_LED_START_BLINK    MSG(TID_LED, 0x03)
#define TMSG_LED_STOP_BLINK     MSG(TID_LED, 0x04)

#define TMSG_ADC_DATA_REQ       MSG(TID_ADC, 0x01)
#define TMSG_ADC_AVEDATA_REQ    MSG(TID_ADC, 0x02)
#define TMSG_ADC_DATA_NOTIFY    MSG(TID_ADC, 0x03)
#define TMSG_ADC_AVEDATA_NOTIFY MSG(TID_ADC, 0x04)

#define TMSG_KICK_TEST1         MSG(TID_KICK, 0x01)
#define TMSG_KICK_TEST2         MSG(TID_KICK, 0x02)

/**
 * Task Main Routine
 */
extern void ledTaskMain(void const *argument);
extern void adcTaskMain(void const *argument);
extern void kickTaskMain(void const *argument);

#endif
