#include "Task.h"
#include "taskdef.h"
#include "adc_task.h"

AnalogIn ain0(A0);
AnalogIn ain1(A1);

void adcTaskMain(void const *argument)
{
    MailPacket *mail;
    Task *self = (Task *)argument;
    
    while (true) {
        mail = self->waitMail();
        switch(mail->messageId) {
        case TMSG_ADC_DATA_REQ: {
            self->log(LOG_INFO, "recieve DATA_REQ");
            AdcData *data = new AdcData;
            data->a0 = ain0.read();
            data->a1 = ain1.read();
            Task::sendMail(TID_KICK, TMSG_ADC_DATA_NOTIFY, data); 
            break;
        }
        case TMSG_ADC_AVEDATA_REQ: {
            int *cnt = (int *)mail->packet;
            float a0 = 0, a1 = 0;
            self->log(LOG_INFO, "recieve AVEDATA_REQ <count=%d>", *cnt);
            for (int i = 0; i < *cnt; i++) {
                a0 += ain0.read(); a1 += ain1.read();
                Thread::wait(1000);
            }
            AdcData *data = new AdcData;
            data->a0 = a0 / *cnt;
            data->a1 = a1 / *cnt;
            Task::sendMail(TID_KICK, TMSG_ADC_AVEDATA_NOTIFY, data); 
            delete cnt, a0, a1;
            break;
        }
        default:
            break;
        }
        self->deleteMail(mail);
    }
}
