#include "Task.h"
#include "taskdef.h"
#include "adc_task.h"

void kickTaskMain(void const *argument)
{
    MailPacket *mail;
    Task *self = (Task *)argument;

    while (true) {
        mail = self->waitMail();
        switch(mail->messageId) {
        case TMSG_ADC_DATA_NOTIFY:
        case TMSG_ADC_AVEDATA_NOTIFY:
        {
            AdcData *data = (AdcData *)mail->packet;
            if (mail->messageId == TMSG_ADC_DATA_NOTIFY) {
                self->log(LOG_INFO, 
                    "recieve ADC_DATA_NOTIFY <a0=%.2f, a1=%.2f>",
                    data->a0, data->a1);
            } else {
                self->log(LOG_INFO, 
                    "recieve ADC_AVEDATA_NOTIFY <a0=%.2f, a1=%.2f>",
                    data->a0, data->a1);
                Task::sendMail(TID_LED, TMSG_LED_STOP_BLINK, NULL);            
            }
            delete data;
            break;
        }
        case TMSG_KICK_TEST1:
            self->log(LOG_INFO, "recieve KICK_TEST1");
            Task::sendMail(TID_ADC, TMSG_ADC_DATA_REQ, NULL);            
            break;
        case TMSG_KICK_TEST2: {
            self->log(LOG_INFO, "recieve KICK_TEST2");
            int *i = new int;
            *i = 10;
            Task::sendMail(TID_LED, TMSG_LED_START_BLINK, NULL);
            Task::sendMail(TID_ADC, TMSG_ADC_AVEDATA_REQ, i);
            break;
        }
        default:
            break;
        }
        self->deleteMail(mail);
    }
}