#include "mbed.h"
#include "Task.h"
#include "taskdef.h"

TaskConfig taskConfig[NUM_OF_TASKS] = {
    TaskConfig(TNAME_LED, ledTaskMain),
    TaskConfig(TNAME_ADC, adcTaskMain, osPriorityAboveNormal),
    TaskConfig(TNAME_KICK, kickTaskMain, osPriorityBelowNormal)
};

int main()
{
    Task::init(taskConfig, NUM_OF_TASKS);
    Task::Logger::setLogLevel(LOG_INFO);

    Task::sendMail(TID_KICK, TMSG_KICK_TEST1, NULL);
    Thread::wait(3000);

    Task::sendMail(TID_KICK, TMSG_KICK_TEST2, NULL);
    Thread::wait(2000);

    Task::sendMail(TID_KICK, TMSG_KICK_TEST1, NULL);

    /** dummy loop */
    while (true) {}
}
