#include "Task.h"
#include "taskdef.h"

DigitalOut led1(LED1);
RtosTimer *blinkTimer;
extern void ledToggle(void const *n);

inline void ledTaskInit()
{
    led1 = 1;
    blinkTimer = new RtosTimer(ledToggle, osTimerPeriodic, NULL);
}

void ledToggle(void const *n)
{
    led1 = !led1;
}

void ledTaskMain(void const *argument)
{
    Task *self = (Task *)argument;

    ledTaskInit();

    while (true) {
        MailPacket *mail = self->waitMail();
        switch(mail->messageId) {
        case TMSG_LED_TURNON:
            self->log(LOG_DEBUG, "TURNON");
            led1 = 0;
            break;
        case TMSG_LED_TURNOFF:
            self->log(LOG_DEBUG, "TURNOFF");
            led1 = 1;
            break;
        case TMSG_LED_START_BLINK:
            self->log(LOG_DEBUG, "START_BLINK");
            blinkTimer->start(1000);
            break;
        case TMSG_LED_STOP_BLINK:
            self->log(LOG_DEBUG, "STOP_BLINK");
            blinkTimer->stop();
            Task::sendMail(TID_LED, TMSG_LED_TURNOFF, NULL);
            break;
        default:
            break;
        }
        self->deleteMail(mail);
    }
}