#include "Task.h"

Timer Task::clock;
Task **Task::taskTable;
TaskConfig *Task::taskConfig;

Stream *Task::Logger::sci = new Serial(USBTX, USBRX);
LogLevel Task::Logger::lv = LOG_WARN;
const char *Task::Logger::lvSym[] = {"D", "I", "W", "E"};

Task::Task(TaskConfig *cfg)
{
    thread = new Thread(
        cfg->routine, this, cfg->priority, cfg->stackSize, cfg->stackPointer);
    logger = new Logger(cfg->name);
}

void Task::init(TaskConfig *cfg, uint32_t num_of_task)
{
    /** set the lowest priority to main thread. */
    osThreadSetPriority(osThreadGetId(), osPriorityIdle);

    taskConfig = cfg;
    taskTable  = new Task*[num_of_task];

    for (int id = 0; id < num_of_task; id++) {
        taskTable[id] = new Task(&taskConfig[id]);
    }

    /** start logger tick */
    clock.start();
}

void Task::sendMail(TaskID task_id, MessageID message_id, void *packet)
{
    MailPacket *mail = taskTable[task_id]->mbox.alloc();
    mail->messageId  = message_id;
    mail->packet     = packet;
    taskTable[task_id]->mbox.put(mail);
}

void Task::deleteMail(MailPacket *mail)
{
    mbox.free(mail);
}

MailPacket *Task::waitMail()
{
    osEvent event;
    while(true) {
        event = mbox.get();
        if (event.status == osEventMail) {
            break;
        } else {
            log(LOG_INFO, "event(%d)recieved", event.status);
        }
    }
    return (MailPacket*)event.value.p;
}

void Task::log(LogLevel lv, const char *format, ...)
{
    if (Logger::lv > lv) return;

    float t = (float)clock.read_ms() / 1000;
    logger->sp->printf("%.3f:[%s][%s] ",
                       t, Logger::lvSym[lv], logger->tag);

    va_list arg;
    va_start(arg, format);
    vsprintf(logger->buf, format, arg);
    va_end(arg);

    logger->sp->printf(logger->buf);
    logger->sp->printf("\n");
}

Task::Logger::Logger(const char *task_name, Stream *sp)
{
    this->tag = task_name;
    this->sp  = sp;
}

void Task::Logger::setLogLevel(LogLevel lv)
{
    Logger::lv = lv;
}
