#include "mbed.h"
#include "MemFileSystem.h"
#include "SDFileSystem.h"

SDFileSystem sd(P8_5, P8_6, P8_3, P8_4, "sd");
Timer timer;

const char *mem_file_path = "/ram/out.txt";
const char *sd_file_path = "/sd/out.txt";
const char *dump_path = "/sd/fatdump";
const int DATA_SIZE = 100 * 1024;
uint8_t data_written[DATA_SIZE] = { 0 };

void writeFile(const char *path)
{
    FILE *f = fopen(path, "w"); 
    for (int i = 0; i < DATA_SIZE; i++) {
        data_written[i] = rand() % 0XFF;
        fprintf(f, "%c", data_written[i]);
    }
    fclose(f);    
}

bool readFile(const char *path)
{
    bool result = true;

    FILE *f = fopen(path, "r");
    for (int i = 0; i < DATA_SIZE; i++) {
        uint8_t data = fgetc(f);
        if (data != data_written[i]) {
            result = false;
            break;
        }
    }
    fclose(f);

    return result;
}

int main()
{    
    MemFileSystem *ramfs1 = new MemFileSystem("ram");
    ramfs1->format();

    /**
     * MemFileSystem read/write test
     */
    {
        printf("Mem: Writing ... ");
        writeFile(mem_file_path);
        printf("[OK]\r\n");
 
        printf("Mem: Reading data ... ");
        printf("[%s]\r\n", readFile(mem_file_path) ? "OK" : "FAIL");
    }

    /**
     * MemFileSystem dump/load test
     */
    {
        printf("Dump from MemFs to SDFs ... ");
        FILE *f = fopen(dump_path, "w");
        ramfs1->dump(f);
        fclose(f);
        printf("[OK]\n");
    }

    delete ramfs1;
    MemFileSystem *ramfs2 = new MemFileSystem("ram");

    {
        printf("Load from SDFs to MemFs ... ");
        FILE *f = fopen(dump_path, "r");
        ramfs2->load(f);
        fclose(f);
        printf("[OK]\n");
    }

    printf("Mem: Reading data ... ");
    printf("[%s]\n", readFile(mem_file_path) ? "OK" : "FAIL");
    
    /*
     * FileSytem speed comparison
     */
    {
        int cnt = 10;
        int s, e;

        timer.start();
        
        s = timer.read_us();
        printf("Mem: Writing 10 times ...");
        for (int i = 0; i < cnt; i++) {
            writeFile(mem_file_path);
        }
        e = timer.read_us();
        printf("[OK] avg = %dusec\n", (e - s) / cnt );

        s = timer.read_us();
        printf("SD: Writing 10 times ...");
        for (int i = 0; i < cnt; i++) {
            writeFile(sd_file_path);
        }
        e = timer.read_us();
        printf("[OK] avg = %dusec\n", (e - s) / cnt );
        
        timer.stop();
    }
}