#include "mbed.h"

#define BTN0_PIN P6_0
#define BTN1_PIN P6_1
#define BTN0_IRQ IRQ5_IRQn
#define BTN1_IRQ IRQ4_IRQn

InterruptIn button0(BTN0_PIN);
InterruptIn button1(BTN1_PIN);
DigitalOut rled(LED_RED);
DigitalOut bled(LED_BLUE);

#define DELAY_CNT 1000000000

void button0_int_handler() {
    rled = 0;
    for (int i = 0; i <= DELAY_CNT; i++) ;
    rled = 1;
}

void button1_int_handler() {
    bled = 0;
    for (int i = 0; i <= DELAY_CNT; i++) ;
    bled = 1;
}

int main() {
    rled = 1;
    bled = 1;
    
    GIC_SetPriority(BTN1_IRQ, 10);      // Pri 10 に落とす
    button0.fall(&button0_int_handler);
    button1.fall(&button1_int_handler);

    while(1) {
        wait(1);
    }
}
