#ifndef USERINTERFACE_H
#define USERINTERFACE_H

/**
* Copyright (c) 2014
* All rights reserved.
*
 * This header file contains functions for reading received signals and checking that they are properly formed.
 * @author Bradley Perry
 * @date
*/

#include "mbed.h"
#include "MODSERIAL.h"
#include "initDatabed.h"
extern int UI;
class UserInterface
{
public:
    UserInterface(void);
    void find_length(char *idx, int *count);
    bool checksum_check(char * idx, int length);
    void checkUI_XBee();
    void readBuffer();
    void initializeUI();

private:
    int _buttonA;
    int _buttonA_prev;
    float _tHold;
    float _tIdle;
    int _SSconfirm;
    float _tRelease;
    Timer _time_StateChange;
    Timer _time_pressA;
    Timer _time_pressB;
    int _buttonB;
    int _buttonB_prev;
    char _xbeeBuffer[250];
    int _dataCnt;
    float _time_sinceA;
    float _time_sinceB;
    int _prev_UI;
};
#endif
