#include "mbed.h"
#include "SDFileSystem.h"
#include "SDFile.h"
#include "errno.h"
#include "initDatabed.h"


SDFile::SDFile(string path, string filename, bool readOnly)
{
    //Creates the necessary directory
    printf("Creating SDFile object\r\n");
    char *a = new char[path.size()+1];
    a[path.size()] = 0;
    memcpy(a,path.c_str(),path.size());
    //Calculates the full filename, then creates the file
    std::string fullname = path + filename;

    char *b = new char[fullname.size()+1];
    b[fullname.size()] = 0;
    memcpy(b,fullname.c_str(),fullname.size());
    if (readOnly) {
        //printf("Opening readonly file\r\n");
        //_fp = fopen((const char*)b, "r");
    } else {
        printf("Opening writable file %s\r\n", b);
        _fp = fopen((const char*)b, "w+");
        if (_fp == NULL) {
            //boardLed3 = 1;
            newFile = true;
            printf("file %s not found\r\n", b);
            _fp = fopen((const char*)b, "w+");
        } else {
            newFile = false;
            printf("file %s found\r\n", b);
        }
    }
    //printf("fp is %d\r\n", _fp);       
}

/**
* This function reads bytes from the SDFile object.
* @author Michael Ling
* @param length    The number of bytes to read
* @param array    The int array the bytes are copied to
* @date 2/2/2015
*/
int* SDFile::read(int length, int *array)
{
   
    //shift to the end of the file and go back accounting for the commas, spaces, \n, and \r (6 places per data)
    fseek(_fp, -6*length, SEEK_END);
    
    //pc.printf("reading to array at %d\r\n", &array[0]);
    //cycle through the length of the vector and read the values.
    for(int i = 0; i < length; i++) {
        //pc.printf("File %d, array %d\r\n", _fp, &array[i]);
        fscanf(_fp, "%x, ", &array[i]);
      //  pc.printf("HHHHH\r\n", s);
        //pc.printf("read %x now at %ld\r\n", array[i], ftell(_fp));
    }
   
    return array;
}

int* SDFile::read_from_start(int length, int *array) {
    fseek(_fp, 0, SEEK_SET);
    for(int i = 0; i < length; i++) {
        fscanf(_fp, "%x, ", &array[i]);
    }
   
    return array;
}

//Debug only--prints file contents, 6 chars to a line for up to 23 lines
void SDFile::debug_print() {
    fseek(_fp, 0, SEEK_SET);
    char c;
    for (int i = 0; i < 23; i++) {
        for (int j = 0; j < 6; j++) {
           fscanf(_fp, "%c", &c);
           pc.printf("%c", c);
        }
        pc.printf("\r\n");
    }
}

/** 
* This function writes from an array to the file pointed to by fp
* @param length    length of data to write
* @param array    array to draw written data from
* @author Michael Ling
* @date 2/2/2015
*/
void SDFile::write(int length, int *array)
{
    //printf("Seeking START...\r\n");
    fseek(_fp, 0, SEEK_SET);
//    printf("Writing %d\r\n", array[0]);
    //printf("Starting to write\r\n");
//    int w;
    for(int i = 0; i < length-1; i++) {
        /* This line fails when run on testFile, reason unknown...*/
        //printf("%d\r\n", fprintf(_fp, "%04x, ", array[i]));
        //pc.printf("Writing at %ld\r\n", ftell(_fp));
        fprintf(_fp, "%04x, ", array[i]);
        //pc.printf("Wrote %x, now at %ld\r\n", array[i], ftell(_fp));
    }
    //printf("%d\r\n", fprintf(_fp, "%04x\r\n", array[length-1]));
    fprintf(_fp, "%04x\r\n", array[length-1]);
    //fflush(_fp);
}

/** This function writes to a single position in the file
* @param index  write to this index of the file, or at offset index*6 from the start
* @param value  the new value to be written to that position
* @author Michael Ling
* @date 4/24/2015
*/
void SDFile::write_to_index(int index, int value)
{
     fseek(_fp, 6*index, SEEK_SET);
    //pc.printf("Index %d, position %ld\r\n", 6*index, ftell(_fp));
    //fscanf(_fp, "%x, ", &val);
    //pc.printf("Val is %x\r\n", val);
    //pc.printf("%d, %d\r\n", sizeof value, sizeof 0xdead);
    //pc.printf("%04x, ", value);
    //The &0xffff forces the float to write only 4 characters--without it floats become 8 chars long, for some reason
    int w = fprintf(_fp, "%04x, ", value & 0xffff); 
    //pc.printf("Wrote %d, now at %ld\r\n", w, ftell(_fp));
    fflush(_fp);
}

void SDFile::append(int length, int *array) {
    fseek(_fp, 0, SEEK_END);
    for(int i = 0; i < length-1; i++) {
        
        fprintf(_fp, "%04x, ", array[i]);
    }
    fprintf(_fp, "%04x\r\n", array[length-1]);
}
/*
void SDFile::changeAccess(string path, string filename) {
    fclose(_fp);
    char *a = new char[path.size()+1];
    a[path.size()] = 0;
    memcpy(a,path.c_str(),path.size());
    //Calculates the full filename, then creates the file
    std::string fullname = path + filename;

    char *b = new char[fullname.size()+1];
    
    b[fullname.size()] = 0;
    memcpy(b,fullname.c_str(),fullname.size());
    printf("Using name %s\r\n", b);
    _fp = fopen((const char *)b, "r+");
    printf("new FP is %d\r\n", _fp);
}*/

void SDFile::open_for_read(string path, string filename) {
     //Creates the necessary directory
    //printf("Trying to open for read\r\n");
    char *a = new char[path.size()+1];
    a[path.size()] = 0;
    memcpy(a,path.c_str(),path.size());
    //Calculates the full filename, then creates the file
    std::string fullname = path + filename;

    char *b = new char[fullname.size()+1];
    b[fullname.size()] = 0;
    memcpy(b,fullname.c_str(),fullname.size());
    _fp = fopen((const char*)b, "r");

    //printf("fp is %d\r\n", _fp);  
}

void SDFile::open_for_write(string path, string filename) {
    
    //Creates the necessary directory
    
    char *a = new char[path.size()+1];
    a[path.size()] = 0;
    memcpy(a,path.c_str(),path.size());
    //Calculates the full filename, then creates the file
    std::string fullname = path + filename;

    char *b = new char[fullname.size()+1];
    b[fullname.size()] = 0;
    memcpy(b,fullname.c_str(),fullname.size());
            _fp = fopen((const char*)b, "w+");

    //printf("fp is %d\r\n", _fp); 
}

void SDFile::close() {
    fclose(_fp);
}        