/**
* @file SDFile.h
* @brief This header file contains read/write functions for the SDFile object
* @author Michael Ling
* @date 2/2/2015
*/

#include <string>

#include "mbed.h"
#include "SDFileSystem.h"

#ifndef SDFILE_H
#define SDFILE_H
class SDFile
{
public:
    SDFile(std::string path, std::string filename, bool readOnly);
    int *read(int length, int *array);
    int *read_from_start(int length, int *array);
    void write(int length, int *array);
    void write_to_index(int index, int value);
    void append(int length, int *array);
 //   void changeAccess(std::string path, std::string filename);
    void open_for_read(std::string path, std::string filename);
    void open_for_write(std::string path, std::string filename);
    void close();
    void debug_print();

private:
    FILE *_fp;
};
#endif
