#include "mbed.h"
#include "USBMouseKeyboard.h"

USBMouseKeyboard key_mouse;

Serial rf_receive(p28, p27);

void processButtons(short b);

/*
 *  parse incoming message data into X, Y, and buttons
 *  move cursor by X, Y
 *  pass buttons along to handler
 */
void processMessage(char* msg)
{
    short x = msg[1] | (msg[2] << 8);
    short y = msg[3] | (msg[4] << 8);
    short button = msg[5] | (msg[6] << 8);
    processButtons(button);
    if (button != 0x00) {
        // pc.printf("rcvd button: %4x \r\n\r\n", button);
    }
    key_mouse.move(x, y);
}


/*
 * process incoming button data, each bit corresponds to a single button
 * allows for multiple button presses froma  single message
 */
void processButtons(short b)
{
    // button 1
    if (((b >> 1) & 0x01) != 0) {
        // left click
        key_mouse.click(MOUSE_LEFT);
    }
    // button 2
    if (((b >> 2) & 0x01) != 0) {
        // Middle click
        key_mouse.click(MOUSE_MIDDLE);
    }
    // button 3
    if (((b >> 3) & 0x01) != 0) {
        // right click
        key_mouse.click(MOUSE_RIGHT);
    }
    // button 5
    if (((b >> 5) & 0x01) != 0) {
        // volume up
        key_mouse.mediaControl(KEY_VOLUME_UP);
    }
    // button 6
    if (((b >> 6) & 0x01) != 0) {
        // scroll up
        key_mouse.scroll(-1);
    }
    // button 7
    if (((b >> 7) & 0x01) != 0) {
        // fwd
        key_mouse.keyCode(RIGHT_ARROW, KEY_ALT);
    }
    // button 9
    if (((b >> 9) & 0x01) != 0) {
        // volume down
        key_mouse.mediaControl(KEY_VOLUME_DOWN);
    }
    // button 10
    if (((b >> 10) & 0x01) != 0) {
        // scroll down
        key_mouse.scroll(1);

    }
    // button 11
    if (((b >> 11) & 0x01) != 0) {
        // back
        key_mouse.keyCode(LEFT_ARROW, KEY_ALT);
    }
}


/*
 * read in bytes when available from the RF receiver
 * read in bytes while looking for start character and validating checksum
 */
int main()
{

    rf_receive.baud(4800);
    int curByte = 0;
    char received[8];
    char checksum= 0;
    while(1) {
        // check if data available for reading
        if (rf_receive.readable()) {

            // read in byte into incoming message array
            received[curByte] = rf_receive.getc();
            // if this is the first byte in the message
            if (curByte == 0) {
                // check if it is the start character, if not, keep overwiting 1st byte
                if (received[curByte] == 0x55) {
                    // if so update checksum and increment message data pointer
                    checksum += received[curByte];
                    curByte++;
                }
                // if received valid start char, read in 6 data bytes, calculating checksum
            } else if (curByte <= 6) {
                checksum += received[curByte];
                curByte++;
            } else { // else check if calculated checksum matches incoming checksum
                if (checksum == received[curByte]) {
                    // if valid message, process data
                    processMessage(received);
                }
                // reset for next message regardless
                curByte = 0;
                checksum = 0;
            }
        }
    }
}
