#include "mbed.h"      

DigitalOut ROW1(PA_0);
DigitalOut ROW2(PA_5);
DigitalOut ROW3(PA_1); 
DigitalOut ROW4(PA_2);
DigitalOut led1(LED1);

DigitalIn COL1(PA_3, PullUp); 
DigitalIn COL2(PB_6, PullUp);
DigitalIn COL3(PB_7, PullUp);
DigitalIn COL4(PD_0, PullUp);

unsigned char keypad_scan(void);
int col_scan(void);

int main()
{
    int row, col;
    while(1)
    {
    unsigned char key1_map = keypad_scan();
    printf("%c", key1_map); 
    }
}

unsigned char keypad_scan(void)
{
    unsigned char key_map [4][4] =
    {
        {'1', '2', '3','A'},
        {'4', '5', '6', 'B'},
        {'7', '8', '9', 'C'},
        {'*', '0', '#', 'D'},
    };
    int row, col;
    unsigned char key = 0xFF; 
    
    for(row =0; row<4; row++)
    {
        ROW1 = 1;
        ROW2 = 1;
        ROW3 = 1;
        ROW4 = 1;
        if(row == 0)
        {
            ROW1 = 0;
            wait(0.005);
            col = col_scan();
            wait(0.005);
        }
        else if(row == 1)
        {
            ROW2 = 0;
            wait(0.005);
            col = col_scan();
            wait(0.005);
        }
        else if(row == 2)
        {
            ROW3 = 0;
            wait(0.005);
            col = col_scan();
            wait(0.005);
        }
        else if(row == 3)
        {
            ROW4 = 0;
            wait(0.005);
            col = col_scan();
            wait(0.005);
        }
        else
        {
            return key;
        }   
    }
    if(col == 0 || col == 1 || col == 2 || col == 3)
        {
            return key_map[row][col];
        }
    return key;
}

int col_scan(void)
{
    unsigned char key = 0xFF;
    if(COL1 == 0)
    {
        return 0;
    }
    else if(COL2 == 0)
    {
        return 1;
    }
    else if(COL3 == 0)
    {
        return 2;
    }
    else if(COL4 == 0)
    {
        return 3;
    }
    else
    {
        return key;
    }   
}