
// uLCD-144-G2 demo program for uLCD-4GL LCD driver library
//
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "wave_player.h"
 
uLCD_4DGL uLCD(p9,p10,p8); // serial tx, serial rx, reset pin;
BusIn joy1(p11,p12,p13,p14,p15);
BusIn joy2(p16,p17,p19,p20,p21);

int player1_direction = 1;
int player2_direction = 2;
bool hitClick;
bool play1 = false;
int choice = 1;
FILE *wave_file;

SDFileSystem sd(p5, p6, p7, p27, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);

// Thread 1
// Joystick 1
void joy1_thread(void const *args) {
    while(true) {
        switch(joy1) {
            case 0x1e: 
            if (player1_direction != 4) {
                player1_direction = 3; 
            }
            break;
            case 0x1d: hitClick = true; break;
            case 0x1b: 
            if (player1_direction != 1) {
                player1_direction = 2; 
            }
            break;
            case 0x17:
            if (player1_direction != 3) {
                player1_direction = 4; 
            }
            break;
            case 0xf: 
            if (player1_direction != 2) {
                player1_direction = 1; 
            }
            break;
        }
        
        Thread::wait(50);
    }
}

// Thread 2
// Joystick 2
void joy2_thread(void const *args) {
    while(true) {
        switch(joy2) {
            case 0x1e: 
            if (player2_direction != 4) {
                player2_direction = 3; 
            }
            break;
            case 0x1d: hitClick = true; break;
            case 0x1b: 
            if (player2_direction != 1) {
                player2_direction = 2; 
            }
            break;
            case 0x17:
            if (player2_direction != 3) {
                player2_direction = 4; 
            }
            break;
            case 0xf: 
            if (player2_direction != 2) {
                player2_direction = 1; 
            }
            break;
        }
        
        Thread::wait(50);
    }
}

int main()
{
    Thread thread(joy1_thread);
    Thread thread2(joy2_thread);
    
    
    while (true) {
        uLCD.filled_rectangle(0, 0, 128, 128, 0x000000);
        uLCD.text_width(4); //4X size text
        uLCD.text_height(4);
        uLCD.color(RED);
        
        
        wave_file=fopen("/sd/wavfiles/dp_tron_start.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        
        for (int i=4; i>=0; --i) {
            uLCD.locate(1.9,1.9);
            uLCD.printf("%d",i);
            Thread::wait(400);
        }
        uLCD.cls();
        
        player1_direction = 1;
        player2_direction = 2;
        int velocity = 2;
        int p1x = 50;
        int p1y = 50;
        int p2x = 100;
        int p2y = 100;
        int size = 2;
        int vel = 2;
        int count = 0;
        int p1xH[1000];
        int p1yH[1000];
        int p2xH[1000];
        int p2yH[1000];
        int lost_player = 0;
        
        
        
        bool game = true;
        uLCD.filled_rectangle(0, 0, 128, 128, 0x000000);
        //draw walls
        uLCD.line(0, 0, 127, 0, WHITE);
        uLCD.line(127, 0, 127, 127, WHITE);
        uLCD.line(127, 127, 0, 127, WHITE);
        uLCD.line(0, 127, 0, 0, WHITE);
        
        uLCD.filled_rectangle(p1x, p1y, p1x + size, p1y + size, 0xFF0000);
        uLCD.filled_rectangle(p2x, p2y, p2x + size, p2y + size, 0x0000FF);
        
        while(game) {
            // check the previous paths
            p1xH[count] = p1x;
            p1yH[count] = p1y;
            p2xH[count] = p2x;
            p2yH[count] = p2y;
            
            // Movement for Player 1
            if (player1_direction == 1) { // moving right
                if (p1x >= 126 - size) {
                    lost_player = 1;
                    game = false;
                } 
                p1x = p1x + vel;
                
            } else if (player1_direction == 2) { // moving left
                if (p1x <= size + 1) {
                    lost_player = 1;
                    game = false;
                }
                p1x = p1x - vel;
            
            } else if (player1_direction == 3) { // moving up
                if (p1y <= size + 1) {
                    lost_player = 1;
                    game = false;
                } 
                p1y = p1y - vel;
            
            } else if (player1_direction == 4) { // moving down
                if (p1y >= 126 - size) {
                    lost_player = 1;
                    game = false;
                }
                p1y = p1y + vel;
            }
            
            
            // Movement for Player 2
            if (player2_direction == 1) { // moving right
                if (p2x >= 126 - size) {
                    lost_player = 2;
                    game = false;
                } 
                p2x = p2x + vel;
            } else if (player2_direction == 2) { // moving left
                if (p2x <= size + 1) {
                    lost_player = 2;
                    game = false;
                }
                p2x = p2x - vel;
            } else if (player2_direction == 3) { // moving up
                if (p2y <= size + 1) {
                    lost_player = 2;
                    game = false;
                } 
                p2y = p2y - vel;
                
            } else if (player2_direction == 4) { // moving down
                if (p2y >= 126 - size) {
                    lost_player = 2;
                    game = false;
                }
                p2y = p2y + vel;
            }
            
            //collision check
            bool found = false;
            for (int i=0; (i < count+1 && !found); i++) {
                // for player 1
                if ((p2xH[i] > (p1x + size)) || ((p2xH[i] + size) < p1x) || ((p2yH[i] + size) < p1y) || (p2yH[i] > (p1y + size))) {
                    
                } else {
                    found = true;
                    game = false;
                    lost_player = 1;
                }
                
                if (i > 0) {
                    int j = i - 1;
                    if ((p1xH[j] >= (p1x + size)) || ((p1xH[j] + size) <= p1x) || ((p1yH[j] + size) <= p1y) || (p1yH[j] >= (p1y + size))) {
                    
                    } else {
                        found = true;
                        game = false;
                        lost_player = 1;
                    }
                }
                
                // for player 2
                if ((p1xH[i] > (p2x + size)) || ((p1xH[i] + size) < p2x) || ((p1yH[i] + size) < p2y) || (p1yH[i] > (p2y + size))) {
                    //test passed
                } else {
                    found = true;
                    game = false;
                    lost_player = 2;
                }
                
                if (i > 0) {
                    int j = i - 1;
                    if ((p2xH[j] >= (p2x + size)) || ((p2xH[j] + size) <= p2x) || ((p2yH[j] + size) <= p2y) || (p2yH[j] >= (p2y + size))) {
                        
                    } else {
                        found = true;
                        game = false;
                        lost_player = 2;
                    }
                }
            }
            
            
            //Drawing the path.
            uLCD.filled_rectangle(p1x, p1y, p1x + size, p1y + size, 0xFF0000);
            uLCD.filled_rectangle(p2x, p2y, p2x + size, p2y + size, 0x0000FF);
            
            
            
            if (!game) {
                uLCD.filled_rectangle(0, 0, 128, 128, 0x000000);
                choice = 2;
                play1 = true;
                uLCD.locate(5,2);
                uLCD.printf("Game over");
                uLCD.locate(3,4);
                uLCD.printf("Player %d LOST", lost_player);
                uLCD.locate(2,9);
                uLCD.color(GREEN);
                uLCD.printf("Click to start!");
                wave_file=fopen("/sd/wavfiles/dp_tron_end.wav","r");
                waver.play(wave_file);
                fclose(wave_file);
                hitClick = false;
                while (!hitClick) {
                    Thread::wait(300);
                }
            }
            count = count + 1;
            Thread::wait(30);
        }
    
    }
    /*if ((x<=radius+1) || (x>=126-radius)) vx = -.90*vx;
        if ((y<=radius+1) || (y>=126-radius)) vy = -.90*vy;*/
//......more code demos can be found in main.cpp
}