#include "mbed.h"                       //libreria mbed standard
#include "MMA8451Q.h"                   //libreria per usare l'acceleratore
#include "tsi_sensor.h"                 //libreria per usare lo slider

#define MMA8451_I2C 0x1d<<1             //indirizzo dell' acceleratore
#define PIN_SLI_10 10                   //   pin che identificano...
#define PIN_SLI_9 9                     //...lo slider
#define RANGE 2                         //valore arbitrario usato per rilevare se lo slider viene toccato
#define SENSITIVITY 0                  //cambiando il valore di una delle 3 assi di una quantità maggiore della SENSITIVITY, avviene la scrittura sulla porta seriale
#define AXES 3                          //numero degli assi
#define SHUT_DOWN 1                     //valore del LED spento
#define MIN_DENSITY 0.9                 //minimo valore della densità per far restare acceso il LED
//#define RED 1                           //codice del colore rosso
//#define GREEN 2                         //codice del colore verde
//#define BLUE 3                          //codice del colore blu
#define BLUE_MARGIN_Y -1/3.0              //margine dopo il quale il LED diventa blu ( si riferisce all'asse y )
#define RED_MARGIN_Z 0                    //margine dopo il quale il LED diventa rosso ( si riferisce all'asse z )

PwmOut red(LED1);
PwmOut green(LED2);
PwmOut blue(LED3);
float density = 0;

void printAxes( float* xyz, float* xyzPrinted );                    //scrive i valori xyz sulla porta seriale
void ledChange( float* xyz );                                       //metodo che verifica in quale colore cambiare il LED
void makeRed();
void makeGreen();
void makeBlue();                        
void densityChange( TSIAnalogSlider tsi );                          //cambia la densità del LED dato l'input dallo slider

int main(){

    MMA8451Q acc( PTE25, PTE24, MMA8451_I2C );                      //creazione dell'oggetto che controlla l'acceleratore
    TSIAnalogSlider tsi( PIN_SLI_9, PIN_SLI_10, RANGE );            //creazione dell'oggetto che controlla lo slider
    
    float* xyz = new float[AXES];
    float* xyzPrinted = new float[AXES];
    
    while(true){
        acc.getAccAllAxis( xyz );
        if( SENSITIVITY == 0 )                                      //il cambiamento di densità si svolge solo in questo caso per motivi pratici
            densityChange( tsi );
        ledChange( xyz );
        printAxes( xyz, xyzPrinted );
    }    
}

void printAxes( float* xyz, float* xyzPrinted ){//, int color ){
    
    for(int i = 0; i < AXES; i += 1)
        if( abs(xyz[i] - xyzPrinted[i]) > SENSITIVITY ){
            for( int i = 0; i < AXES; i += 1 ){
                //printf("%c: %.2f ", (unsigned char)i+88, xyz[i]);
                printf("%.2f:", xyz[i]);        //stampa valori dell'inclinazione delimitati con ":"
                xyzPrinted[i] = xyz[i];         //              |
            }                                   //              V
            printf("\n" );            //in aggiunta stampa codice colore ( cancellato, era: printf("%d\r\n", color); )
            fflush(stdout);
        }
}

void ledChange( float* xyz ){
    
    //int color;                              
    if( xyz[1] < BLUE_MARGIN_Y ){                      //xyz[1] è l'asse y
        makeBlue();
        //color = BLUE;
    }
    else if( xyz[2] < RED_MARGIN_Z ){                  //xyz[2] è l'asse z
        makeRed();
        //color = RED;
    }
    else{
        makeGreen();
        //color = GREEN;
    }
    
    //return color;
}

void makeRed(){
    
    red   = density;
    green = SHUT_DOWN;
    blue  = SHUT_DOWN;
}

void makeGreen(){
    
    red   = SHUT_DOWN;
    green = density;
    blue  = SHUT_DOWN;
}

void makeBlue(){
    
    red   = SHUT_DOWN;
    green = SHUT_DOWN;
    blue  = density;
}

void densityChange( TSIAnalogSlider tsi ){

    if( tsi.readDistance() != 0 )                                          //se lo slider viene toccato
        if( (density = SHUT_DOWN - tsi.readPercentage()) > MIN_DENSITY )   //aggiorna la densità e controlla se il LED è "quasi spento"
            density = SHUT_DOWN;                                           //spegne il LED completamente
}