#include "mbed.h"

DigitalOut l1(LED1);
DigitalOut l2(LED2);
DigitalOut l3(LED3);

PwmOut uH(p21);//high side 
PwmOut vH(p22);
PwmOut wH(p23);

PwmOut uL(p24);//low side
PwmOut vL(p25);
PwmOut wL(p26);

InterruptIn u(p16);//hole sensor
InterruptIn v(p17);
InterruptIn w(p18);

Serial pc(USBTX,USBRX);

int p,dir;
float period = 1;
float pulse = period / 10;

void mode(int);
void out(float,float,float,float,float,float);
void A();void B();void C();
void D();void E();void F();
void LED(int,int,int);

void init(){
    u.mode(PullUp);
    v.mode(PullUp);
    w.mode(PullUp);
    
    uH.period_us(period);
    vH.period_us(period);
    wH.period_us(period);
    uH.pulsewidth_us(pulse);
    vH.pulsewidth_us(pulse);
    wH.pulsewidth_us(pulse);
    
    uL.period_us(period);
    vL.period_us(period);
    wL.period_us(period);
    uL.pulsewidth_us(pulse);
    vL.pulsewidth_us(pulse);
    wL.pulsewidth_us(pulse);

    p = 0;//start
    dir = 0;// 0/1 <=> CW/CCW
}

int main() {
    init();
    u.rise(&A);
    w.fall(&B);
    v.rise(&C);
    u.fall(&D);
    w.rise(&E);
    v.fall(&F);
    while(1) {
        mode(p);
        //wait_us(1);
        //pc.printf("%d\n",p);
    }
    return 0;
}

void mode(int p){
    switch(p){
        case 0:
            out(1,1,1,0,0,0);
            LED(1,1,1);
            break;
        case 1:
            out(0,1,1,0,1,0);
            LED(1,0,0);
            break;
        case 2:
            out(0,1,1,0,0,1);
            LED(1,0,0);
            break;
        case 3:
            out(1,0,1,0,0,1);
            LED(0,1,0);
            break;
        case 4:
            out(1,0,1,1,0,0);
            LED(0,1,0);
            break;
        case 5:
            out(1,1,0,1,0,0);
            LED(0,0,1);
            break;
        case 6:
            out(1,1,0,0,1,0);
            LED(0,0,1);
            break;
        default:
            out(1,1,1,0,0,0);
            LED(0,0,0);
            break;
    }
}

void out(float uh,float vh,float wh,float ul,float vl,float wl){
    uL.write(ul);
    vL.write(vl);
    wL.write(wl);
    uH.write(uh);
    vH.write(vh);
    wH.write(wh);
}

void LED(int i,int ii,int iii){
    l1 = i;
    l2 = ii;
    l3 = iii;
} 

void A(){
    if(dir == 0)p = 1;
    else p = 3;}
void B(){
    if(dir == 0)p = 2;
    else p = 4;}
void C(){
    if(dir == 0)p = 3;
    else p = 5;}
void D(){
    if(dir == 0)p = 4;
    else p = 6;}
void E(){
    if(dir == 0)p = 5;
    else p = 1;}
void F(){
    if(dir == 0)p = 6;
    else p = 2;}
    