#include "mbed.h"
#include "ShiftReg.h"

ShiftReg::ShiftReg(PinName data, PinName store, PinName clock, PinName enable ): _ds(data), _st(store), _sh(clock), _en(enable)//Constructor
{
    _en = 1;   
}
void ShiftReg::Write (uint16_t  data)
{
    uint16_t mask; 
    mask = 0x8000;
    for (uint8_t i = 0; i < 16; i++)
    {       
        if (data & mask)
        {
            _ds = 1;
        }
        else
        {
            _ds = 0;
        }
    
         mask = mask >> 1;
        
        _sh = 0;
        _sh = 1;
    }
    //Latch
    _st = 1;
    _st = 0;
    //Latch
    _en = 0;
}
void ShiftReg::ShiftByte (uint16_t  data, BitOrd  ord )
{
    uint16_t mask;
    if (ord == MSBFirst) 
    {       
        mask = 0x8000;
    }
    else
    {
        mask = 0x0001;
    }
    for (uint8_t i = 0; i < 16; i++)
    {
        //_ds = data;
        
        if (data & mask)
        {
            _ds = 1;
        }
        else
        {
            _ds = 0;
        }
        if (ord == MSBFirst)
        {   
            mask = mask >> 1;
        }
        else
        {
            mask = mask << 1;
        }
        _sh = 0;
        _sh = 1;
    }
    _en = 0;
}
void ShiftReg::ShiftBit(int8_t  data)
{
    _ds = data;
    _sh = 0;
    _sh = 1;
}

void ShiftReg::Latch()
{
  _st = 1;
  _st = 0;
}
