#include "mbed.h"
#include "rtos.h"
#include "Filter.hpp"

unsigned short ADC_DATA;

//Init  values for difference equation
//MBED Class Instances follows
DigitalOut SampLED(LED1);              //Digital Output  (GREEN LED is PB_3, D13 You can use an Oscilloscope on This pin to confirm sample rate)

//Analog Inputs
AnalogIn  Ain(PA_1);                    //Analog Input (Signal Input 0 to +3 Volts)
AnalogOut Aout(PA_4);                   //Analog Output (Signal Input 0 to +3 Volts)

//Declare Threads
Thread t1;

    
//Declare Ticker Rates
float sample_rate = (1.0/35000);        //Rate of sampling

//Initial Input Value
float input = 0.0;


//Declare Filter
FILTER BP_filter(48000,70,16,1);  //Create object of type Filter(Fs,Fo,Boost,Q)


//Forward Declarations
void sampler(void);


int main()
{
    t1.start(sampler);//Start the Sampler timed interrupt
    BP_filter.Define_Filter();
    BP_filter.Print_Filter();
}

void sampler(void)
{
    while(1)
    {
        SampLED = 1;//LED Indicates start of sampling
        input = Ain;//Takes ADC input  as a Varaible type float
        BP_filter.setvalue(input);//Input ADC. N.B. ADC in MBED is 0.0 to 1.0 float!!!!!!
        Aout = BP_filter.getvalue();//Sets the input value to the Class
        SampLED = 0;//LED Indicates end of sampling
        Thread::wait(sample_rate*1000);//Look at this
    }
}
