#include "mbed.h"
#include "rtos.h"
#include "Filter.hpp"
unsigned short ADC_DATA;

//Init  values for difference equation
//MBED Class Instances follows
DigitalOut SampLED(LED1);              //Digital Output  (GREEN LED is PB_3, D13 You can use an Oscilloscope on This pin to confirm sample rate)

AnalogIn  Ain(PA_1);                    //Analog Input (Signal Input 0 to +3 Volts)
AnalogOut Aout(PA_4);                   //Analog Output (Signal Input 0 to +3 Volts)

Ticker sample_timer;
Thread T1;
Thread T2;

float input = 0.0;
FILTER BP_filter(48000,10,16,1600);  //Create object of type Filter(Fs,Fo,Boost,Q)


void sampler(void);


int main()
{
    
    BP_filter.Define_Filter();
    float sample_rate = (1.0/35000) ;
    sample_timer.attach(&sampler,sample_rate);;

    while(1) {

    }
}


void sampler(void)
{

    SampLED = 1;                        //LED Indicates start of sampling

    input = Ain;
    BP_filter.setvalue(input);       //Input ADC. N.B. ADC in MBED is 0.0 to 1.0 float!!!!!!
    Aout = BP_filter.getvalue();
    

    SampLED = 0;      //LED Indicates end of sampling
}

