 /* Copyright (c) 2015 NXP Semiconductors. MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include "FXAS21002.h"
#include "FXOS8700.h"  
#include "MPL3115.h" 
#include "mbed.h"

// Initialize Serial port
Serial pc(USBTX, USBRX);


// Initialize pins for I2C communication for sensors. Set jumpers J6,J7 in FRDM-STBC-AGM01 board accordingly.
FXOS8700 accel(PTE25,PTE24);
FXOS8700 mag(PTE25,PTE24);
FXAS21002 gyro(PTE25,PTE24);
MPL3115 mpl3115(PTE25,PTE24);

//FXAS21002 gyro(PTC2,PTC1);
//MPL3115 mpl3115(PTC2,PTC1);

    
int main()
{
     

// Configure Accelerometer FXOS8700, Magnetometer FXOS8700 & Gyroscope FXAS21002
    accel.accel_config();
    mag.mag_config();
    gyro.gyro_config();
    mpl3115.MPL3115_config();
 
    pc.baud(115200);
    
    float accel_data[3];
    float accel_rms=0.0;
    float mag_data[3];
    float mag_rms=0.0;
    float gyro_data[3];
    float gyro_rms=0.0;
    float alt_data[3];
    float alt_rms=0.0;
       
    printf("Begin Data Acquisition....\r\n\r\n");
    wait(5.0);
    
    while(1)
    {
      accel.acquire_accel_data_g(accel_data);
      accel_rms = sqrt(((accel_data[0]*accel_data[0])+(accel_data[1]*accel_data[1])+(accel_data[2]*accel_data[2]))/3);
      printf("Accelleration readings: X:%4.2f, Y:%4.2f, Z:%4.2f\n",accel_data[0],accel_data[1],accel_data[2]);
      printf("Accelleration RMS: %4.2f\n",accel_rms);
      wait(0.005);
         
      mag.acquire_mag_data_uT(mag_data);
      printf("Magnetics readings: X:%4.2f, Y:%4.2f, Z:%4.2f\n",mag_data[0],mag_data[1],mag_data[2]);
      mag_rms = sqrt(((mag_data[0]*mag_data[0])+(mag_data[1]*mag_data[1])+(mag_data[2]*mag_data[2]))/3);
      printf("Magnetic RMS: %4.2f\n",mag_rms);
      wait(0.005);

     
      gyro.acquire_gyro_data_dps(gyro_data);
      printf("Gyroscope readings: X:%4.2f, Y:%4.2f, Z:%4.2f\n",gyro_data[0],gyro_data[1],gyro_data[2]);
      gyro_rms = sqrt(((gyro_data[0]*gyro_data[0])+(gyro_data[1]*gyro_data[1])+(gyro_data[2]*gyro_data[2]))/3);
      printf("Gyroscopic RMS: %4.2f\n",gyro_rms);
      wait(0.005);
      
      mpl3115.acquire_MPL3115_data_Altitude_in_m(alt_data);
      printf("Altitude: \t%f\n",alt_data[0]);
      alt_rms = sqrt(((alt_data[0]*alt_data[0])+(alt_data[1]*alt_data[1])+(alt_data[2]*alt_data[2]))/3);
      printf("Altitude RMS: %4.2f\n",alt_rms);
      wait(0.005);
      
      printf("\f");
      //printf("\033[2J");
      wait(0.1);
   
      
     }
      
}