/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "Road.h"
#include "AccCar.h"
#include "TextLCD.h"

// main() runs in its own thread in the OS
int main() {
    Communication::init();
    wait(1);
    printf("starting simulation/r/n");
    // ------------------------------------------------------------------------------
    // The following three variables are used for timing statistics, do not modify them
    Timer stopwatch;    // A timer to keep track of how long the updates take, for statistics purposes
    int numberCycles = 0;
    int totalUpdateTime = 0;
    // ------------------------------------------------------------------------------

    int time = 0;

    Road road1;

    stopwatch.start();
    stopwatch.reset();
    
    int return_cars[MAX_CARS];
    
    do {
        Road::ready(0);
        Communication::yield(50); 

        int new_cars = road1.try_enter_car(time);
        Communication::yield(50); 

        road1.let_cars_update();
        Communication::yield(50); 
        printf("main.cpp: update flags raised\n");
                
        road1.wait_for_car_update();
        printf("main.cpp: finished updating\n"); 
                
        printf("\r\nRoad 1 Update %d\r\n", time);
        road1.print_status();

        printf("\r\n");
        road1.check_exit_cars(return_cars);

        time++;
        
        // ------------------------------------------------------------------
        // Timing statistics logic, do not modify
        totalUpdateTime += stopwatch.read_ms();
        numberCycles++;
        stopwatch.reset();
        // ------------------------------------------------------------------

        road1.publish_car_info();
        printf("successful publish: car info\r\n");
        Communication::publish_road_ready();
        
        Communication::yield(50); 
        while(Road::ready(-1) == 0) {
            Communication::yield(50); 
        }
        road1.update_wait_counter(); 
        printf("----------------------\r\n"); 
    } while( road1.active_cars > 0x00);
    
    // ----------------------------------------------------------------------
    // Timing statistics printout, do not modify
    printf("Average Wait Time: %fs \r\n", road1.wait_counter / 5.0); 
    printf("Average update cycle took: %fms \r\n", (totalUpdateTime*1.0)/(numberCycles*1.0));
    totalUpdateTime = 0;
    numberCycles = 0;
    // ----------------------------------------------------------------------
    while (true) {
        Communication::publish_road_ready();
        wait(0.1); 
    }
}
