#ifndef _COMMUNICATION_H_
#define _COMMUNICATION_H_

#include <string.h>
#include "mbed.h"
#include "Road.h"
#include "MQTTNetwork.h"
#include "MQTTClient.h"
#include "MQTTmbed.h"

class Communication {
public:
    static int init();
    static int publish_car_info(int id, int pos, int speed);
    static int publish_road_ready();
    static void update_message_arrived(MQTT::MessageData& md);
    static void sync_message_arrived(MQTT::MessageData& md);
    static void disconnect();
    static void yield(int time); 
    
private:
    static MQTT::Client<MQTTNetwork, Countdown>* client(MQTT::Client<MQTTNetwork, Countdown>* client);
    static const char* mac_address(const char* new_add);

    Communication();
    static WiFiInterface* setup_wifi();
    static MQTT::Client<MQTTNetwork, Countdown>* setup_mqtt(MQTTNetwork &network);

};
#endif